package com.paypal.hybris.apitestingservice.service;

import de.hybris.platform.core.model.order.OrderModel;

import java.math.BigDecimal;

public interface ApitestingPaymentService {

    public boolean doCapture(OrderModel order, BigDecimal amount, String transactionId);

    public boolean doAuthorize(OrderModel order, BigDecimal amount);

    public boolean doReauthorize(OrderModel order, BigDecimal amount, String transactionId);

    public boolean isValidTransactionId(OrderModel order, String transactionId);

    public boolean doReturn(OrderModel order, boolean returnDeliveryCost, BigDecimal amount);

    public boolean doCancel(OrderModel order);
}
