package com.paypal.hybris.apitestingservice.facades;

import de.hybris.platform.core.model.user.UserModel;
import de.hybris.platform.servicelayer.config.ConfigurationService;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.servicelayer.user.UserService;
import de.hybris.platform.servicelayer.user.daos.UserDao;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserUiAutomationFacadeIml {

    private static final Logger LOG = Logger.getLogger(UserUiAutomationFacadeIml.class);

    @Autowired
    private ConfigurationService configurationService;

    @Autowired
    private UserDao userDao;

    @Autowired
    private ModelService modelService;

    @Autowired
    private UserService userService;

    public Boolean removeCarts(String userUID) {
        UserModel user = userService.getUserForUID(userUID);
        if (user != null) {
            LOG.info("Remove All Carts for user with ID: " + user.getUid() + ", name: " + user.getName() + ".");
            modelService.removeAll(user.getCarts());
            modelService.saveAll();
            modelService.refresh(user);
            return true;
        } else {
            return false;
        }
    }
}
