package com.paypal.hybris.apitestingservice.facades;

import de.hybris.platform.servicelayer.config.ConfigurationService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import paypalhac.services.PayPalButtonConfigurationService;

import java.util.Map;

@Component
public class PropertyUiAutomationFacadeIml {

    private static final Logger LOG = Logger.getLogger(PropertyUiAutomationFacadeIml.class);
    private static final String REQUIRE_BILLING_ADDRESS = "paypal.requireBillingAddress";
    private static final String SET_EXPRESS_CHECKOUT_ADDRESS_OVERRIDE = "paypal.setExpressCheckout.address.override";
    private static final String CART_BUTTON_CONFIG = "cart.button.config";
    private static final String MINI_CART_BUTTON_CONFIG = "mini.cart.button.config";
    private static final String MARK_BUTTON_CONFIG = "mark.button.config";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String ONE = "1";
    private static final String ZERO = "0";

    @Autowired
    private ConfigurationService configurationService;

    @Autowired
    private PayPalButtonConfigurationService payPalButtonConfigurationService;

    public Boolean setRequireBillingAddress(String propertyValue) {
        if (!TRUE.equalsIgnoreCase(propertyValue) && !FALSE.equalsIgnoreCase(propertyValue)) {
            LOG.error("Property must be 'true' or 'false'. Current value: " + propertyValue);
            return false;
        }
        return setProperty(REQUIRE_BILLING_ADDRESS, propertyValue);
    }

    public Boolean setExpressCheckoutAddressOverride(String propertyValue) {
        if (!ONE.equalsIgnoreCase(propertyValue) && !ZERO.equalsIgnoreCase(propertyValue)) {
            LOG.error("Property must be '1' or '0'. Current value: " + propertyValue);
            return false;
        }
        return setProperty(SET_EXPRESS_CHECKOUT_ADDRESS_OVERRIDE, propertyValue);
    }

    public void setPropertyMap(final Map<String, String> propertyMap) {
        for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
            configurationService.getConfiguration().setProperty(entry.getKey(), entry.getValue());
        }
    }

    private Boolean setProperty(String property, String value) {
        configurationService.getConfiguration().setProperty(property, value.toLowerCase());
        return configurationService.getConfiguration().getString(property).equalsIgnoreCase(value);
    }

    /**
     * @deprecated      
     */
    @Deprecated
    public Boolean deletePayPalButtonCustomConfig() {
        try {
            payPalButtonConfigurationService.setProperty(CART_BUTTON_CONFIG, "");
            payPalButtonConfigurationService.setProperty(MINI_CART_BUTTON_CONFIG, "");
            payPalButtonConfigurationService.setProperty(MARK_BUTTON_CONFIG, "");
        } catch (Exception e) {
            String message = "Error with deleting paypal button custom config: " + e.getMessage();
            LOG.error(message);
            return false;
        }
        return true;
    }

}
