package com.paypal.hybris.apitestingservice.facades;

import de.hybris.platform.core.model.order.AbstractOrderModel;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import de.hybris.platform.servicelayer.search.SearchResult;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PayPalCsCockpitFacadeIml {

    private static final Logger LOG = Logger.getLogger(PayPalCsCockpitFacadeIml.class);
    private static final String ORDER_ID = "orderID";

    @Autowired
    private FlexibleSearchService flexibleSearchService;

    private static final String GET_ORDER_ADDRESS_BY_ID = "SELECT {pk} FROM {" + OrderModel._TYPECODE
        + "}  WHERE {" + AbstractOrderModel.CODE + "} = ?orderID";

    private OrderModel getOrderById(String orderID) {
        final FlexibleSearchQuery flexibleSearchQuery = new FlexibleSearchQuery(GET_ORDER_ADDRESS_BY_ID);
        flexibleSearchQuery.addQueryParameter(ORDER_ID, orderID);
        SearchResult<OrderModel> resultSet = flexibleSearchService.search(flexibleSearchQuery);

        if (resultSet.getResult().isEmpty()) {
            LOG.info("Order " + orderID + "not found");
            return null;
        }

        return resultSet.getResult().get(0);
    }

}
