import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';

import { AppComponent } from './app.component';
import { translations, translationChunksConfig } from '@spartacus/assets';
import { B2cStorefrontModule } from '@spartacus/storefront';
import { PaypalStorefrontModule, defaultPaypalCheckoutConfig } from 'paypal-spartacus-storefront';
import {provideDefaultConfig} from '@spartacus/core';

@NgModule({
  declarations: [
    AppComponent
  ],
  imports: [
    BrowserModule,
    PaypalStorefrontModule.withConfig({
      paypalCheckout: {
        allowGuestExpressCheckout: true
      }
    }),
    B2cStorefrontModule.withConfig({
      backend: {
        occ: {
           baseUrl: 'https://localhost:9002',
          prefix: '/rest/v2/'
        }
      },
      context: {
        currency: ['USD'],
        language: ['en'],
        baseSite: ['electronics-spa']
      },
      i18n: {
        resources: translations,
        chunks: translationChunksConfig,
        fallbackLang: 'en'
      },
      checkout: {
        guest: true
      },
      features: {
        level: '3.1'
      }
    })
  ],
  providers: [provideDefaultConfig(defaultPaypalCheckoutConfig)],
  bootstrap: [AppComponent]
})
export class AppModule { }
