import {ModuleWithProviders, NgModule} from '@angular/core';
import {CommonModule} from '@angular/common';
import {CmsConfig, ConfigModule, I18nModule, provideConfig, UrlModule} from '@spartacus/core';
import {PaypalNewPaymentMethodComponent, PaypalPaymentMethodComponent} from './components/billing-page';
import {
  CardModule,
  CartNotEmptyGuard,
  CheckoutAuthGuard,
  FormErrorsModule,
  IconModule, OrderConfirmationGuard, PromotionsModule,
  SpinnerModule,
  CartComponentModule,
  B2cStorefrontModule, OrderConfirmationModule, PwaModule,
  TruncateTextPopoverModule, ScheduleReplenishmentOrderModule
} from '@spartacus/storefront';
import {PaypalCoreModule} from 'paypal-spartacus-core';
import {PaypalCartTotalComponent} from './components/cart-page/paypal-cart-total/paypal-cart-total.component';
import {PaypalCartComponent} from './components/cart-page/paypal-cart/paypal-cart.component';
import {RouterModule, Routes} from '@angular/router';

import {FormsModule, ReactiveFormsModule} from '@angular/forms';
import {PaypalHostedFieldsComponent} from './components/paypal-hosted-fields/paypal-hosted-fields.component';
import {NgSelectModule} from '@ng-select/ng-select';
import {PaypalReplenishmentOrderComponent} from './components/order/paypal-replenishment-order/paypal-replenishment-order.component';
import {paypalTranslationChunksConfig, paypalTranslations} from './translations';
import {PaypalCheckoutConfig} from './config/paypal-checkout-config';
import {PaypalPaymentInfoComponent} from './components/shared/paypal-payment-info/paypal-payment-info.component';
import {PaypalPaymentMethodsComponent} from './components/my-account/paypal-payment-methods/paypal-payment-methods.component';
import {PaypalReviewOrderComponent} from './components/order/paypal-review-order/paypal-review-order.component';
import {PaypalOrderOverviewComponent} from './components/order/paypal-order-overview/paypal-order-overview.component';
import {PaypalOrderConfirmationComponent} from './components/order/paypal-order-confirmation/paypal-order-confirmation.component';
import {PaypalOrderConfirmationThankYouMessageComponent} from './components/order/paypal-order-confirmation-thank-you-message/paypal-order-confirmation-thank-you-message.component';
import {PaypalPlaceOrderComponent} from './components/order/paypal-place-order/paypal-place-order.component';
import {PaypalCreditMessageComponent} from './components/shared/paypal-credit-message/paypal-credit-message.component';
import {PaypalOrderDetailsShippingComponent} from './components/order/paypal-order-details-shipping/paypal-order-details-shipping.component';
import {PaypalConnectComponent} from './components/login-page';
import {PaypalConnectWaitingComponent} from './components/login-page/paypal-connect-waiting/paypal-connect-waiting.component';
import {PaypalConnectAdditionalComponent} from './components/login-page/paypal-connect-additional/paypal-connect-additional.component';

const staticRoutes: Routes = [];

@NgModule({
  declarations: [
    PaypalPaymentMethodComponent,
    PaypalNewPaymentMethodComponent,
    PaypalCartTotalComponent,
    PaypalCartComponent,
    PaypalHostedFieldsComponent,
    PaypalReplenishmentOrderComponent,
    PaypalPaymentInfoComponent,
    PaypalPaymentMethodsComponent,
    PaypalReviewOrderComponent,
    PaypalOrderOverviewComponent,
    PaypalOrderConfirmationComponent,
    PaypalPlaceOrderComponent,
    PaypalOrderConfirmationThankYouMessageComponent,
    PaypalCreditMessageComponent,
    PaypalOrderDetailsShippingComponent,
    PaypalConnectComponent,
    PaypalConnectWaitingComponent,
    PaypalConnectAdditionalComponent
  ],
  imports: [
    PaypalCoreModule,
    CommonModule,
    ConfigModule.withConfig({
      cmsComponents: {
        ReplenishmentConfirmationMessageComponent: {
          component: PaypalOrderConfirmationThankYouMessageComponent,
          guards: [OrderConfirmationGuard],
        },
        OrderConfirmationThankMessageComponent: {
          component: PaypalOrderConfirmationThankYouMessageComponent,
          guards: [OrderConfirmationGuard],
        },
        ReplenishmentConfirmationOverviewComponent: {
          component: PaypalOrderConfirmationComponent,
          guards: [OrderConfirmationGuard],
        },
        OrderConfirmationOverviewComponent: {
          component: PaypalOrderConfirmationComponent,
          guards: [OrderConfirmationGuard],
        },
        CheckoutPaymentDetails: {
          component: PaypalPaymentMethodComponent,
          //  TODO(#8880): Shouldn't we keep ShippingAddressSetGuard and others here?
          guards: [CheckoutAuthGuard, CartNotEmptyGuard],
        },
        CartTotalsComponent: {
          component: PaypalCartTotalComponent
        },
        CheckoutScheduleReplenishmentOrder: {
          component: PaypalReplenishmentOrderComponent,
          guards: [CheckoutAuthGuard, CartNotEmptyGuard],
        },
        AccountPaymentDetailsComponent: {
          component: PaypalPaymentMethodsComponent,
        },
        CheckoutReviewOrder: {
          component: PaypalReviewOrderComponent,
          guards: [CheckoutAuthGuard, CartNotEmptyGuard],
        },
        CheckoutPlaceOrder: {
          component: PaypalPlaceOrderComponent,
          guards: [CheckoutAuthGuard, CartNotEmptyGuard],
        },
        PayPalCreditMessageComponentSPA: {
          component: PaypalCreditMessageComponent,
        },
        AccountOrderDetailsShippingComponent: {
          component: PaypalOrderDetailsShippingComponent,
        },
        ReplenishmentDetailShippingComponent: {
          component: PaypalOrderDetailsShippingComponent,
        },
        PayPalConnectButtonComponentSPA: {
          component: PaypalConnectComponent
        },
        PayPalConnectAdditionalComponentB2C: {
          component: PaypalConnectWaitingComponent
        },
        PayPalConnectAdditionalComponentB2B: {
          component: PaypalConnectAdditionalComponent
        }
      },
    } as CmsConfig),
    B2cStorefrontModule.withConfig({
      i18n: {
        resources: paypalTranslations,
        chunks: paypalTranslationChunksConfig,
        fallbackLang: 'en',
      }
    }),
    SpinnerModule,
    CardModule,
    CartComponentModule,
    RouterModule.forChild(staticRoutes),
    UrlModule,
    I18nModule,
    FormsModule,
    ReactiveFormsModule,
    NgSelectModule,
    FormErrorsModule,
    IconModule,
    TruncateTextPopoverModule,
    PromotionsModule,
    OrderConfirmationModule,
    PwaModule,
    ScheduleReplenishmentOrderModule
  ],
  providers: [],
  exports: [PaypalPaymentMethodComponent, PaypalNewPaymentMethodComponent]
})
export class PaypalStorefrontModule {

  static withConfig(
    config?: PaypalCheckoutConfig
  ): ModuleWithProviders<PaypalStorefrontModule> {
    return {
      ngModule: PaypalStorefrontModule,
      providers: [provideConfig(config)],
    };
  }

}
