import {Component, Input, OnInit} from '@angular/core';
import {CardComponent} from '@spartacus/storefront';
import {Observable} from 'rxjs';
import {OccConfig, PaymentDetails} from '@spartacus/core';

@Component({
  selector: 'paypal-payment-info',
  templateUrl: './paypal-payment-info.component.html'
})
export class PaypalPaymentInfoComponent extends CardComponent implements OnInit {

  @Input()
  editMode = false;

  @Input()
  paymentDetails: PaymentDetails;

  @Input()
  title: Observable<string>;

  contextPath: string;

  constructor(
    protected config: OccConfig
  ) {
    super();
  }


  ngOnInit(): void {
    super.ngOnInit();
    this.contextPath = this.config.backend.occ.baseUrl;
  }
}
