import {Component, OnInit} from '@angular/core';
import {Card, CheckoutStepService, PromotionService, ReviewSubmitComponent} from '@spartacus/storefront';
import {
  ActiveCartService,
  CheckoutCostCenterService,
  CheckoutDeliveryService,
  CheckoutPaymentService,
  PaymentDetails,
  PaymentTypeService,
  TranslationService,
  UserAddressService,
  UserCostCenterService
} from '@spartacus/core';
import {Observable} from 'rxjs';
import {map} from 'rxjs/operators';
import {PageType, PaypalCheckoutData, PaypalPaymentDetailsService, PaypalPaymentMethodPresentationService} from 'paypal-spartacus-core';

@Component({
  selector: 'paypal-review-order',
  templateUrl: './paypal-review-order.component.html'
})
export class PaypalReviewOrderComponent extends ReviewSubmitComponent implements OnInit {

  public checkoutData$: Observable<PaypalCheckoutData>;

  constructor(
    protected checkoutDeliveryService: CheckoutDeliveryService,
    protected checkoutPaymentService: CheckoutPaymentService,
    protected userAddressService: UserAddressService,
    protected activeCartService: ActiveCartService,
    protected translation: TranslationService,
    protected promotionService: PromotionService,
    protected checkoutStepService: CheckoutStepService,
    protected paymentTypeService: PaymentTypeService,
    protected checkoutCostCenterService: CheckoutCostCenterService,
    protected userCostCenterService: UserCostCenterService,
    protected paymentMethodPresentationService: PaypalPaymentMethodPresentationService,
    protected paypalPaymentDetailsService: PaypalPaymentDetailsService
  ) {
    super(
      checkoutDeliveryService,
      checkoutPaymentService,
      userAddressService,
      activeCartService,
      translation,
      promotionService,
      checkoutStepService,
      paymentTypeService,
      checkoutCostCenterService,
      userCostCenterService);
  }

  ngOnInit(): void {
    this.checkoutData$ = this.paypalPaymentDetailsService.loadPaymentDetails(PageType.MARK);
  }


  getPayPalPaymentMethodCard(paymentDetails: PaymentDetails, checkoutData: PaypalCheckoutData): Observable<Card> {
    return super.getPaymentMethodCard(paymentDetails)
    .pipe(
      map(content => {
        return this.paymentMethodPresentationService.preparePaymentMethod(content, paymentDetails, checkoutData);
      })
    );
  }

}
