import {Component, OnInit} from '@angular/core';
import {PaypalPaymentDetailsService} from 'paypal-spartacus-core';
import {map} from 'rxjs/operators';
import {Observable} from 'rxjs';

@Component({
  selector: 'paypal-replenishment-order',
  templateUrl: './paypal-replenishment-order.component.html',
})
export class PaypalReplenishmentOrderComponent implements OnInit {

  isReplenishmentAvailable$: Observable<boolean>;

  constructor(
      protected paypalPaymentDetailsService: PaypalPaymentDetailsService
  ) {
  }

  ngOnInit(): void {
    this.isReplenishmentAvailable$ = this.paypalPaymentDetailsService
    .loadPaymentDetails('mark')
    .pipe(
        map((checkoutData) => {
          return checkoutData.configurationData.isBillingAgreementFlowEnabled;
        })
    );
  }

}
