import {Component, ViewContainerRef} from '@angular/core';
import {CheckoutReplenishmentFormService, LaunchDialogService, PlaceOrderComponent} from '@spartacus/storefront';
import {CheckoutPaymentService, PaymentDetails, RoutingService} from '@spartacus/core';
import {FormBuilder} from '@angular/forms';
import {PaypalCheckoutService} from 'paypal-spartacus-core';
import {Observable} from 'rxjs';

@Component({
  selector: 'paypal-place-order',
  templateUrl: './paypal-place-order.component.html',
})
export class PaypalPlaceOrderComponent extends PlaceOrderComponent {

  paymentDetails$: Observable<PaymentDetails>;

  constructor(
    protected checkoutService: PaypalCheckoutService,
    protected routingService: RoutingService,
    protected fb: FormBuilder,
    protected checkoutReplenishmentFormService: CheckoutReplenishmentFormService,
    protected launchDialogService: LaunchDialogService,
    protected vcr: ViewContainerRef,
    protected checkoutPaymentService: CheckoutPaymentService
  ) {
    super(
      checkoutService,
      routingService,
      fb,
      checkoutReplenishmentFormService,
      launchDialogService,
      vcr
    );
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.paymentDetails$ = this.checkoutPaymentService.getPaymentDetails();
  }


}
