import {Component, OnInit} from '@angular/core';
import {Card, OrderOverviewComponent} from '@spartacus/storefront';
import {PaymentDetails, TranslationService} from '@spartacus/core';
import {Observable} from 'rxjs';
import {map} from 'rxjs/operators';
import {PageType, PaypalCheckoutData, PaypalPaymentDetailsService, PaypalPaymentMethodPresentationService} from 'paypal-spartacus-core';

@Component({
  selector: 'paypal-order-overview',
  templateUrl: './paypal-order-overview.component.html'
})
export class PaypalOrderOverviewComponent extends OrderOverviewComponent implements OnInit {

  public checkoutData$: Observable<PaypalCheckoutData>;

  constructor(
    protected translation: TranslationService,
    protected paymentMethodPresentationService: PaypalPaymentMethodPresentationService,
    protected paypalPaymentDetailsService: PaypalPaymentDetailsService
  ) {
    super(translation);
  }

  ngOnInit(): void {
    this.checkoutData$ = this.paypalPaymentDetailsService.loadPaymentDetails(PageType.MARK);
  }

  getPayPalPaymentInfoCardContent(payment: PaymentDetails, checkoutData: PaypalCheckoutData): Observable<Card> {
    return super.getPaymentInfoCardContent(payment).pipe(
      map(content => {
        let result = this.paymentMethodPresentationService.preparePaymentMethod(content, payment, checkoutData);
        result.paragraphs = [];
        return result;
    }));
  }

}
