import {Component, OnDestroy, OnInit} from '@angular/core';
import {Observable} from 'rxjs';
import {ActiveCartService, Cart, CheckoutService, ORDER_TYPE} from '@spartacus/core';
import {map, tap} from 'rxjs/operators';

@Component({
  selector: 'paypal-order-confirmation-thank-you-message',
  templateUrl: './paypal-order-confirmation-thank-you-message.component.html',
})
export class PaypalOrderConfirmationThankYouMessageComponent implements OnInit, OnDestroy {

  order$: Observable<any>;
  cart$: Observable<Cart>;
  isReplenishmentOrderType$: Observable<boolean>;
  isGuestCustomer = false;
  orderGuid: string;

  constructor(protected checkoutService: CheckoutService,
              protected activeCartService: ActiveCartService) {}

  ngOnInit() {
    this.order$ = this.checkoutService.getOrderDetails().pipe(
      tap((order) => {
        this.isGuestCustomer =
          'guestCustomer' in order ? order.guestCustomer ?? false : false;
        this.orderGuid = order.guid as string;
      })
    );

    this.cart$ = this.activeCartService.getActive();

    this.isReplenishmentOrderType$ = this.checkoutService
      .getCurrentOrderType()
      .pipe(
        map(
          (orderType) => ORDER_TYPE.SCHEDULE_REPLENISHMENT_ORDER === orderType
        )
      );
  }

  ngOnDestroy() {
    this.checkoutService.clearCheckoutData();
  }

}
