import {Component, OnInit} from '@angular/core';
import {Card, PaymentMethodsComponent} from '@spartacus/storefront';
import {PaymentDetails, TranslationService, UserPaymentService} from '@spartacus/core';
import {Observable} from 'rxjs';
import {map} from 'rxjs/operators';
import { PaypalPaymentMethodPresentationService } from 'paypal-spartacus-core';

@Component({
  selector: 'paypal-payment-methods',
  templateUrl: './paypal-payment-methods.component.html'
})
export class PaypalPaymentMethodsComponent extends PaymentMethodsComponent implements OnInit {

  constructor(
    userPaymentService: UserPaymentService,
    translation: TranslationService,
    protected paymentMethodPresentationService: PaypalPaymentMethodPresentationService
  ) {
    super(userPaymentService, translation);
  }

  getCardContent(paymentMethod: PaymentDetails): Observable<Card> {
    return super.getCardContent(paymentMethod).pipe(map(value => {
      return  this.paymentMethodPresentationService.preparePaymentMethod(value, paymentMethod);
    }));
  }

}
