import {Component, OnDestroy, OnInit} from '@angular/core';
import {CmsComponentData} from '@spartacus/storefront';
import {PageType, PayPalConnectComponent, PaypalConnectService, PaypalPaymentDetailsService} from 'paypal-spartacus-core';
import {combineLatest, Observable, Subscription} from 'rxjs';
import {ActivatedRoute} from '@angular/router';

@Component({
  selector: 'paypal-connect',
  templateUrl: './paypal-connect.component.html'
})
export class PaypalConnectComponent implements OnInit, OnDestroy {

  componentData$: Observable<PayPalConnectComponent>;
  private subscription: Subscription;
  private defaultWindowOpen;

  constructor(
    protected component: CmsComponentData<PayPalConnectComponent>,
    protected paypalPaymentDetailsService: PaypalPaymentDetailsService,
    protected activatedRoute: ActivatedRoute,
    protected paypalConnectService: PaypalConnectService
  ) {
  }

  ngOnInit(): void {
    this.activatedRoute.queryParams
    .subscribe(params => {
      const forced = params['forced'];
      if(forced) {
        localStorage.setItem('forced', 'true');
      } else {
        localStorage.setItem('forced', 'false');
      }
    });
    this.defaultWindowOpen = window.open;
    window.open = function(a, b, c, d) {
      window.location.href = a;
      return null;
    };
    this.componentData$ = this.component.data$;
    this.subscription = combineLatest(
      [this.componentData$,
        this.paypalPaymentDetailsService.loadPaymentDetails(PageType.LOGIN)])
    .subscribe(([componentData, checkoutData]) => {
      this.paypalConnectService.initializeConnectWithPayPal(componentData, checkoutData.configurationData);
    });
  }

  ngOnDestroy(): void {
    this.subscription.unsubscribe();
    window.open = this.defaultWindowOpen;
  }

}
