import {Component, ElementRef, EventEmitter, Input, OnInit, Output, ViewChild} from '@angular/core';
import {PaypalPaymentDetailsService, PaypalCheckoutData, PayPalButtonStyle, PageType, PaypalCartCheckoutService} from 'paypal-spartacus-core';
import {combineLatest, Observable} from 'rxjs';
import { OCC_USER_ID_ANONYMOUS, UserIdService, OccConfig } from '@spartacus/core';
import {PaypalCheckoutConfigService} from '../../../services/paypal-checkout-config.service';

@Component({
  selector: 'paypal-cart',
  templateUrl: './paypal-cart.component.html',
})
export class PaypalCartComponent implements OnInit {

  checkoutData: PaypalCheckoutData;
  loadedCheckoutData$: Observable<PaypalCheckoutData>;
  payPalButtonStyle: PayPalButtonStyle;
  contextPath: string;
  pageType = PageType.CART;

  @ViewChild('paypalButtonContainer') paypalButton: ElementRef;

  @Input()
  paymentMethodsCount: number;

  @Output()
  backToPaymentMethods = new EventEmitter<any>();

  constructor(
    protected paypalPaymentDetailsService: PaypalPaymentDetailsService,
    protected paypalCartCheckoutService: PaypalCartCheckoutService,
    protected config: OccConfig,
    protected userIdService: UserIdService,
    protected paypalCheckoutConfigService: PaypalCheckoutConfigService

  ) { }

  ngOnInit(): void {
    this.contextPath = this.config.backend.occ.baseUrl;
    if (!this.isAnonymousUser() || this.paypalCheckoutConfigService.isAllowedGuestExpressCheckout()) {
      this.loadedCheckoutData$ = this.paypalPaymentDetailsService.loadPaymentDetails('cart');
      combineLatest(
        [this.paypalPaymentDetailsService.loadPaypalButtonStyles('cart'),
          this.paypalPaymentDetailsService.loadPaymentDetails('cart')])
        .subscribe(([buttonStyle, checkoutData]) => {
          this.checkoutData = checkoutData;
          this.payPalButtonStyle = buttonStyle;
          this.initializeCartPage();
        })
    }
  }

  initializeCartPage(): void {

    if (!this.checkoutData.configurationData.isExpressCheckoutStaticImageFlow
      && this.checkoutData.payPalPaymentMethod.payPalExpressEnabled ) {
      this.paypalCartCheckoutService.initializePayPalCheckout(
        this.checkoutData.configurationData,
        this.pageType,
        this.paypalButton.nativeElement,
        this.payPalButtonStyle);
    }
  }

  processBillingAgreementExpressCheckout(): void {
    this.paypalPaymentDetailsService.processBillingAgreementExpressCheckout();
  }

  isAnonymousUser(): boolean{
    let userId;
    this.userIdService
      .getUserId()
      .subscribe((occUserId) => (userId = occUserId))
      .unsubscribe();
    return OCC_USER_ID_ANONYMOUS === userId;
  }

}


