import {Component} from '@angular/core';
import {Card, CheckoutStepService, PaymentMethodComponent} from '@spartacus/storefront';
import {
  ActiveCartService,
  CheckoutDeliveryService,
  CheckoutService,
  GlobalMessageService,
  PaymentDetails,
  TranslationService,
  UserPaymentService
} from '@spartacus/core';
import {ActivatedRoute} from '@angular/router';
import {PaypalCheckoutPaymentService, PaypalPaymentMethodPresentationService} from 'paypal-spartacus-core';

@Component({
  selector: 'paypal-payment-method',
  templateUrl: './paypal-payment-method.component.html',
})
export class PaypalPaymentMethodComponent extends PaymentMethodComponent {

  constructor(
    protected userPaymentService: UserPaymentService,
    protected checkoutService: CheckoutService,
    protected checkoutDeliveryService: CheckoutDeliveryService,
    protected paypalCheckoutPaymentService: PaypalCheckoutPaymentService,
    protected globalMessageService: GlobalMessageService,
    protected activatedRoute: ActivatedRoute,
    protected translation: TranslationService,
    protected activeCartService: ActiveCartService,
    protected checkoutStepService: CheckoutStepService,
    protected paymentMethodPresentationService: PaypalPaymentMethodPresentationService
  ) {
    super(
      userPaymentService,
      checkoutService,
      checkoutDeliveryService,
      paypalCheckoutPaymentService,
      globalMessageService,
      activatedRoute,
      translation,
      activeCartService,
      checkoutStepService
    );
  }

  preparePaymentDetails(
    content: Card,
    paymentMethod: PaymentDetails
  ): Card {
    return this.paymentMethodPresentationService.preparePaymentMethod(content, paymentMethod);
  }

}
