import {NgModule} from '@angular/core';
import {CommonModule} from '@angular/common';
import {PaymentAdapter} from '../paypal-checkout/connectors/payment.adapter';
import {PaypalPaymentAdapter} from './adapters/paypal-payment.adapter';
import {CheckoutPaymentAdapter, OccModule, UserPaymentAdapter} from '@spartacus/core';
import {PaypalCheckoutPaymentAdapter} from './adapters/paypal-checkout-payment-adapter';
import {CheckoutAdapter} from '../paypal-checkout/connectors/checkout.adapter';
import {ConnectAdapter} from '../paypal-checkout/connectors/connect.adapter';
import {PaypalCheckoutAdapter} from './adapters/paypal-checkout.adapter';
import {PaypalUserPaymentAdapter} from './adapters/paypal-user-payment.adapter';
import {PaypalCheckoutReplenishmentOrderAdapter} from '../paypal-checkout/connectors/paypal-checkout-replenishment-order.adapter';
import {PaypalOccCheckoutReplenishmentOrderAdapter} from './adapters/paypal-occ-checkout-replenishment-order.adapter';
import {PaypalConnectAdapter} from './adapters/paypal-connect.adapter';


@NgModule({
  declarations: [],
  providers: [
    {
      provide: PaymentAdapter,
      useClass: PaypalPaymentAdapter,
    },
    {
      provide: CheckoutPaymentAdapter,
      useClass: PaypalCheckoutPaymentAdapter,
    },
    {
      provide: CheckoutAdapter,
      useClass: PaypalCheckoutAdapter,
    },
    {
      provide: UserPaymentAdapter,
      useClass: PaypalUserPaymentAdapter,
    },
    {
      provide: PaypalCheckoutReplenishmentOrderAdapter,
      useClass: PaypalOccCheckoutReplenishmentOrderAdapter,
    },
    {
      provide: ConnectAdapter,
      useClass: PaypalConnectAdapter,
    }
  ],
  imports: [
    CommonModule,
    OccModule
  ]
})
export class PaypalOccModule { }
