import {Injectable} from '@angular/core';
import {HttpClient, HttpHeaders} from '@angular/common/http';
import {
  ConverterService,
  Occ,
  OccEndpointsService,
  OccUserPaymentAdapter,
  PAYMENT_DETAILS_NORMALIZER,
  PaymentDetails,
  UserPaymentAdapter
} from '@spartacus/core';
import {Observable, throwError} from 'rxjs';
import {catchError, map} from 'rxjs/operators';

@Injectable()
export class PaypalUserPaymentAdapter extends OccUserPaymentAdapter implements UserPaymentAdapter {

  constructor(
    protected http: HttpClient,
    protected occEndpoints: OccEndpointsService,
    protected converter: ConverterService
  ) {
    super(http, occEndpoints, converter);
  }

  loadAll(userId: string): Observable<PaymentDetails[]> {

    const url =
      this.occEndpoints.buildUrl('paymentDetailsAll', {
        urlParams: { userId },
      }) + '?saved=true' + '&fields=FULL';

    const headers = new HttpHeaders({
      'Content-Type': 'application/json',
    });

    return this.http
    .get<Occ.PaymentDetailsList>(url, { headers })
    .pipe(
      catchError((error: any) => throwError(error)),
      map((methodList) => methodList.payments),
      this.converter.pipeableMany(PAYMENT_DETAILS_NORMALIZER)
    );
  }

}
