import {Injectable} from '@angular/core';
import {Observable} from 'rxjs';
import {HttpClient, HttpHeaders, HttpParams} from '@angular/common/http';
import {ConverterService, OccEndpointsService, PaymentDetails} from '@spartacus/core';
import {PaypalCheckoutData} from '../../paypal-checkout/models/paypal-payment-data.model';
import {
  PAYPAL_BUTTON_STYLE_NORMALIZER,
  PAYPAL_CHECKOUT_DATA_NORMALIZER,
} from '../../paypal-checkout/converters/converters';
import {PaymentAdapter} from '../../paypal-checkout/connectors/payment.adapter';
import {PayPalButtonStyle} from '../../paypal-checkout';

@Injectable()
export class PaypalPaymentAdapter implements PaymentAdapter {

  constructor(
    protected http: HttpClient,
    protected occEndpoints: OccEndpointsService,
    protected converter: ConverterService
  ) {}

  protected getEndpoint(userId): string{
    return this.occEndpoints.getEndpoint('/users/' + userId + '/paypal/payment');
  }

  public loadCheckoutData(
    pageType: string,
    userId: string
  ): Observable<PaypalCheckoutData>{

    const params = new HttpParams()
      .set('pageType', pageType);

    return this.http.get( this.getEndpoint(userId), { params })
      .pipe(this.converter.pipeable(PAYPAL_CHECKOUT_DATA_NORMALIZER));
  }


  public loadPaypalButtonStyles(
    pageType: string,
    userId: string
  ): Observable<PayPalButtonStyle>{

    const params = new HttpParams()
      .set('buttonType', pageType);

    const url = `${this.getEndpoint(userId)}/button`;

    return this.http.get( url, { params })
      .pipe(this.converter.pipeable(PAYPAL_BUTTON_STYLE_NORMALIZER));
  }
}
