import {PaypalCheckoutReplenishmentOrderAdapter} from '../../paypal-checkout/connectors/paypal-checkout-replenishment-order.adapter';
import {HttpClient, HttpHeaders, HttpParams} from '@angular/common/http';
import {
  ConverterService,
  Occ,
  OccEndpointsService,
  REPLENISHMENT_ORDER_FORM_SERIALIZER,
  REPLENISHMENT_ORDER_NORMALIZER,
  ReplenishmentOrder
} from '@spartacus/core';
import ScheduleReplenishmentForm = Occ.ScheduleReplenishmentForm;
import {Observable} from 'rxjs';
import {Injectable} from '@angular/core';

@Injectable()
export class PaypalOccCheckoutReplenishmentOrderAdapter implements PaypalCheckoutReplenishmentOrderAdapter
{

  constructor(
    protected http: HttpClient,
    protected occEndpoints: OccEndpointsService,
    protected converter: ConverterService
  ) {}


  scheduleReplenishmentOrder(
    cartId: string,
    scheduleReplenishmentForm: ScheduleReplenishmentForm,
    termsChecked: boolean,
    userId: string
  ): Observable<ReplenishmentOrder> {

    scheduleReplenishmentForm = this.converter.convert(scheduleReplenishmentForm, REPLENISHMENT_ORDER_FORM_SERIALIZER);

    const headers = new HttpHeaders().set('Content-Type', 'application/json');

    const params = new HttpParams()
      .set('termsChecked', termsChecked.toString())
      .set('cartId', cartId);

    const url = this.occEndpoints.getEndpoint('/users/' + userId + '/paypal/orders/replenishmentOrders');

    return this.http
      .post(
        url,
        scheduleReplenishmentForm,
        { headers , params}
      )
      .pipe(this.converter.pipeable(REPLENISHMENT_ORDER_NORMALIZER));
  }

}
