import {Injectable} from '@angular/core';
import {PageType, PaypalConfiguration} from '../../models/paypal-payment-data.model';

@Injectable({
  providedIn: 'root'
})
export class PaypalUtilsService {

  private _savePaymentInfo = false;

  constructor() {
  }

  toggleSavePaymentInfo(flag: boolean): void {
    this._savePaymentInfo = flag;
  }

  loadPayPalSDK(configurationData: PaypalConfiguration, pageType: PageType, onload?: Function): void {
    let buyerCountry = '';
    let locale = '';
    let components = '';
    let disableFunding = '';
    let commit = '';
    let vault = 'false';
    let intent = configurationData.intent;
    let enableFunding = '';

    if (configurationData.isBillingAgreementFlowEnabled || PageType.LOGIN === pageType) {
      vault = 'true';
      intent = 'tokenize';
    }

    if (pageType === PageType.MARK) {
      if (configurationData.environmentType === 'sandbox'){
        buyerCountry = '&buyer-country=' + configurationData.buyerCountry;
        locale = '&locale=' + configurationData.locale;
      }
      if (configurationData.isVenmoEnabled) {
        enableFunding = '&enable-funding=venmo'
      }
      commit = '&commit=' + configurationData.commit;
    }

    //TODO add creditmessage enabled
    if (pageType === PageType.CART ){
      components = '&components=buttons';
      if(!configurationData.isBillingAgreementEnabled) {
        components += ',messages';
        if(configurationData.isVenmoEnabled) {
          enableFunding = '&enable-funding=venmo'
        }
      }
      if (configurationData.environmentType === 'sandbox') {
        buyerCountry = '&buyer-country=' + configurationData.buyerCountry;
      }
      commit = '&commit=false';
    } else if (pageType !== PageType.MARK && !configurationData.isBillingAgreementEnabled) {
      components = '&components=messages';
    }

    if(pageType === PageType.LOGIN) {
      components = '&components=buttons';
      if (configurationData.environmentType === 'sandbox'){
        buyerCountry = '&buyer-country=' + configurationData.buyerCountry;
        locale = '&locale=' + configurationData.locale;
      }
    }

    if (configurationData.disableFunding ){
      disableFunding = '&disable-funding=' + configurationData.disableFunding;
    }

    if(configurationData.isPayLaterEnabledForNonUsCountries && pageType !== PageType.LOGIN) {
      if(enableFunding) {
        enableFunding += ',paylater';
      } else {
        enableFunding = '&enable-funding=paylater'
      }
    }

    const body = document.body as HTMLDivElement;
    const script = document.createElement('script');
    script.innerHTML = '';

    script.src = configurationData.payPalSdkUrl + 'client-id=' + configurationData.client_id + commit + disableFunding + '&intent=' +
      intent + '&vault=' + vault + '&currency=' + configurationData.currency + buyerCountry + locale + components + enableFunding;

    // TODO add partnerAttributionId for cart page
    script.setAttribute('data-namespace', 'paypalSdk');
    script.async = false;
    script.defer = true;
    script.onload = () => {
      if (onload) {
        onload();
      }
    };
    body.appendChild(script);
  }

  loadConnectWithPayPalSdk(configurationData: PaypalConfiguration, onload?: Function) {
    const body = document.body as HTMLDivElement;
    const script = document.createElement('script');
    script.innerHTML = '';
    script.src = configurationData.payPalConnectScript;
    script.async = false;
    script.defer = true;
    script.onload = () => {
      if (onload) {
        onload();
      }
    };
    body.appendChild(script);
  }


  get savePaymentInfo(): boolean {
    return this._savePaymentInfo;
  }

  set savePaymentInfo(value: boolean) {
    this._savePaymentInfo = value;
  }
}
