import {Injectable} from '@angular/core';
import {PageType, PayPalButtonStyle, PaypalConfiguration} from '../../models';
import {PaypalUtilsService} from '../utils';
import {PaypalPaymentDetailsService} from '../../facade';
import {PaypalProcessPaymentCheckoutService} from './paypal-process-payment-checkout.service';

@Injectable({
  providedIn: 'root'
})
export class PaypalLoginService {

  constructor(
    protected paypalUtilsService: PaypalUtilsService,
    protected paypalPaymentDetailsService: PaypalPaymentDetailsService,
    protected paypalProcessPaymentCheckoutService: PaypalProcessPaymentCheckoutService
  ) {
  }

  initializePayPalButton(
    configurationData: PaypalConfiguration,
    accessToken: string,
    payPalButtonContainer,
    buttonStyle: PayPalButtonStyle,
    onSuccessCallback
  ): void {
    this.paypalUtilsService.loadPayPalSDK(configurationData, PageType.LOGIN, () => {
      this.renderBillingAgreementButton(payPalButtonContainer, buttonStyle, accessToken, onSuccessCallback);
    });
  }

  renderBillingAgreementButton(
    payPalButtonContainer,
    buttonStyle: PayPalButtonStyle,
    accessToken: string,
    onSuccessCallback
  ): void {
    try {
      if (typeof (window as any).paypalSdk !== undefined) {
        let fundingSource;

        (window as any).paypalSdk.Buttons({
          style: buttonStyle,

          onClick: (button) => {
            fundingSource = button.fundingSource;
          },

          createBillingAgreement: () => {
            return this.paypalPaymentDetailsService.createBillingAgreementTokenWithoutCart().toPromise()
            .then((res) => {
              return res.tokenId;
            });
          },
          onApprove: (data) => {

            return this.paypalProcessPaymentCheckoutService.savePaymentDetailsForNewUser(data, accessToken, onSuccessCallback, fundingSource);
          },
          onError: (err) => {
            console.error('Error: ' + err, err);
          }
        }).render(payPalButtonContainer);

      }
    } catch (err) {
      console.log(err.message);
    }
  }

}
