import {NgModule} from '@angular/core';
import {CommonModule} from '@angular/common';
import {PaypalPaymentDetailsService} from './facade/paypal-payment-details.service';
import {PaypalPaymentDetailsConnector} from './connectors/paypal-payment-details.connector';
import {PaypalCheckoutDetailsConnector} from './connectors/paypal-checkout-details.connector';
import {PaypalCheckoutStoreModule} from './paypal-checkout-store/paypal-checkout-store.module';
import {PaypalCheckoutReplenishmentOrderConnector} from './connectors/paypal-checkout-replenishment-order.connector';
import {HttpErrorHandler} from '@spartacus/core';
import {PaypalErrorHandlerService} from './services/utils/paypal-error-handler.service';
import {PaypalConnectConnector} from './connectors/paypal-connect.connector';


@NgModule({
  declarations: [
  ],
  providers: [
    PaypalPaymentDetailsService,
    PaypalPaymentDetailsConnector,
    PaypalCheckoutDetailsConnector,
    PaypalCheckoutReplenishmentOrderConnector,
    PaypalConnectConnector,
    {
      provide: HttpErrorHandler,
      useExisting: PaypalErrorHandlerService,
      multi: true
    }
  ],
  imports: [
    CommonModule,
    PaypalCheckoutStoreModule.forRoot()
  ]
})
export class PaypalCheckoutModule { }
