import {Injectable} from '@angular/core';
import {Actions, Effect, ofType} from '@ngrx/effects';
import {PaypalCheckoutReplenishmentOrderConnector} from '../../connectors/paypal-checkout-replenishment-order.connector';
import {CartActions, CheckoutActions, normalizeHttpError} from '@spartacus/core';
import {catchError, map, mergeMap, switchMap} from 'rxjs/operators';
import {Observable, of} from 'rxjs';
import {PaypalReplenishmentOrderAction} from '../actions/index';

@Injectable()
export class PaypalReplenishmentOrderEffect
{

  constructor(
    private actions$: Actions,
    private paypalCheckoutReplenishmentOrderConnector: PaypalCheckoutReplenishmentOrderConnector
  ) {}

  @Effect()
  paypalScheduleReplenishmentOrder$: Observable<
    | CheckoutActions.ScheduleReplenishmentOrderSuccess
    | CheckoutActions.ScheduleReplenishmentOrderFail
    | CartActions.RemoveCart
    > = this.actions$.pipe(
    ofType(PaypalReplenishmentOrderAction.PAYPAL_SCHEDULE_REPLENISHMENT_ORDER),
    map((action: PaypalReplenishmentOrderAction.PaypalScheduleReplenishmentOrder) => action.payload),
    mergeMap((payload) => {
      return this.paypalCheckoutReplenishmentOrderConnector
        .scheduleReplenishmentOrder(
          payload.cartId,
          payload.scheduleReplenishmentForm,
          payload.termsChecked,
          payload.userId
        )
        .pipe(
          switchMap((data) => [
            new CartActions.RemoveCart({ cartId: payload.cartId }),
            new CheckoutActions.ScheduleReplenishmentOrderSuccess(data),
          ]),
          catchError((error) =>
            of(
              new CheckoutActions.ScheduleReplenishmentOrderFail(
                normalizeHttpError(error)
              )
            )
          )
        );
    })
  );

}
