import {CheckoutActions, normalizeHttpError, SiteContextActions, withdrawOn} from '@spartacus/core';
import {Actions, Effect, ofType} from '@ngrx/effects';
import {PaypalCheckoutDetailsConnector} from '../../connectors/paypal-checkout-details.connector';
import {catchError, map, mergeMap} from 'rxjs/operators';
import {Observable, of} from 'rxjs';
import {Injectable} from '@angular/core';
import {PaypalCheckoutAction } from '../actions/index';

@Injectable()
export class PaypalCheckoutEffect {

  constructor(
    private actions$: Actions,
    private paypalCheckoutDetailsConnector: PaypalCheckoutDetailsConnector,
  ) {}

  private contextChange$ = this.actions$.pipe(
    ofType(
      SiteContextActions.CURRENCY_CHANGE,
      SiteContextActions.LANGUAGE_CHANGE
    )
  );


  @Effect()
  setPaypalPaymentDetails$: Observable<
    | CheckoutActions.SetPaymentDetailsSuccess
    | CheckoutActions.SetPaymentDetailsFail
    > = this.actions$.pipe(
    ofType(PaypalCheckoutAction.SET_PAYPAL_PAYMENT_DETAILS),
    map((action: any) => action.payload),
    mergeMap((payload) => {
      console.log('setPaypalPaymentDetails$');
      return this.paypalCheckoutDetailsConnector
        .setPayPalPaymentMethod(payload.userId, payload.cartId, payload.paymentDetails.id)
        .pipe(
          map(
            () =>
              new CheckoutActions.SetPaymentDetailsSuccess(
                payload.paymentDetails
              )
          ),
          catchError((error) =>
            of(
              new CheckoutActions.SetPaymentDetailsFail(
                normalizeHttpError(error)
              )
            )
          )
        );
    }),
    withdrawOn(this.contextChange$)
  );

}
