import {Occ, PLACED_ORDER_PROCESS_ID, PROCESS_FEATURE, StateUtils} from '@spartacus/core';
import ScheduleReplenishmentForm = Occ.ScheduleReplenishmentForm;

export const PAYPAL_SCHEDULE_REPLENISHMENT_ORDER =
  'PayPal Schedule Replenishment Order';

export class PaypalScheduleReplenishmentOrder extends StateUtils.EntityLoadAction {
  readonly type = PAYPAL_SCHEDULE_REPLENISHMENT_ORDER;
  constructor(
    public payload: {
    cartId: string;
    scheduleReplenishmentForm: ScheduleReplenishmentForm;
    termsChecked: boolean;
    userId: string;
  }
) {
    super(PROCESS_FEATURE, PLACED_ORDER_PROCESS_ID);
  }
}

export type PaypalReplenishmentOrderAction =
  | PaypalScheduleReplenishmentOrder
