
export enum PageType{
  MARK = 'mark',
  CART = 'cart',
  LOGIN = 'login'
}

export enum Fields{
  Basic = 'BASIC',
  Default = 'DEFAULT',
  Full = 'FULL'
}

export enum PaymentType {
  PAYPAL = 'paypal',
  LPM = 'local_payment',
  VENMO = 'venmo',
  CARD='card'

}

export interface PaypalAddress {
  recipientName?: string;
  type?: string;
  streetAddress?: string;
  extendedAddress?: string;
  locality?: string;
  countryCodeAlpha2?: string;
  postalCode?: string;
  region?: string;
  phone?: string;
  line1?: string;
  line2?: string;
  city?: string;
  countryCode?: string;
  state?: string;
}

export interface PaypalConfiguration {
  client_id?: string;
  intent?: string;
  commit?: boolean;
  payPalSdkUrl?: string;
  partnerAttributionId?: string;
  environmentType?: string;
  disableFunding?: string;
  currency?: string;
  locale?: string;
  buyerCountry?: string;
  isBillingAgreementFlowEnabled?: boolean;
  isBillingAgreementEnabled?: boolean;
  isExpressCheckoutStaticImageFlow?: boolean;
  isVenmoEnabled?: boolean;
  isPayLaterEnabledForNonUsCountries?: boolean;
  staticImageUrl?: string;
  venmoIconUrl?: string;
  payPalConnectScript?: string;
  payPalConnectScopes?: string;
  payPalConnectResponseType?: string;
  payPalConnectReturnUrl?: string;
}

export interface PaypalPaymentMethod {
  payPalExpressEnabled?: boolean;
  billingAgreementDescription?: string;
}

export interface PaymentImageUrl{
  key: string;
  value: string;
}

export interface CreditCardPaymentMethod{
  hostedFieldsEnable?: boolean;
  paymentsImagesUrl?: Array<PaymentImageUrl>;
}

export interface PaypalCheckoutData {
  shippingAddressOverride?: PaypalAddress;
  enableShippingAddress?: boolean;
  configurationData?: PaypalConfiguration;
  payPalPaymentMethod?: PaypalPaymentMethod;
  creditCardPaymentMethod?: CreditCardPaymentMethod;
}
