import {Injectable} from '@angular/core';
import {PaypalPaymentDetailsConnector} from '../connectors/paypal-payment-details.connector';
import {ActiveCartService, CheckoutService, MultiCartService, PaymentDetails, UserIdService} from '@spartacus/core';
import {Observable} from 'rxjs';
import {Fields, PaypalCheckoutData} from '../models/paypal-payment-data.model';
import {AddingPaymentMethodAndAddressStatusData, PayPalBillingAgreementPaymentRequest, PayPalButtonStyle} from '../models';
import {PaypalCheckoutDetailsConnector} from '../connectors/paypal-checkout-details.connector';
import {PayPalBillingAgreementToken, PaypalOrder, PayPalPaymentRequest} from '../models/paypa-checkout-data.model';
import {takeWhile} from 'rxjs/operators';
import {Router} from '@angular/router';
import {CheckoutDetailsService} from '@spartacus/storefront';
import {PaypalConnectConnector} from '../connectors/paypal-connect.connector';

@Injectable({
  providedIn: 'root'
})
export class PaypalPaymentDetailsService {

  constructor(
    protected userIdService: UserIdService,
    protected activeCartService: ActiveCartService,
    protected paymentConnector: PaypalPaymentDetailsConnector,
    protected checkoutConnector: PaypalCheckoutDetailsConnector,
    protected connectConnector: PaypalConnectConnector,
    protected router: Router,
    protected checkoutService: CheckoutService,
    protected checkoutDetailsService: CheckoutDetailsService,
    protected multiCartService: MultiCartService
  ) { }

  public loadPaymentDetails(pageType: string): Observable<PaypalCheckoutData> {
    let userId;
    this.userIdService
      .getUserId()
      .subscribe((occUserId) => (userId = occUserId))
      .unsubscribe();
    return this.paymentConnector.loadPaymentDetails(pageType, userId);
  }


  public loadPaypalButtonStyles(
    pageType: string
  ): Observable<PayPalButtonStyle>{
    let userId;
    this.userIdService
      .getUserId()
      .subscribe((occUserId) => (userId = occUserId))
      .unsubscribe();
    return this.paymentConnector.loadPaypalButtonStyles(pageType, userId);
  }

  processBillingAgreementExpressCheckout() {
    let userId;
    let cartId;
    this.userIdService
      .getUserId()
      .subscribe((occUserId) => (userId = occUserId))
      .unsubscribe();
    this.activeCartService
      .getActiveCartId()
      .subscribe((occCartId) => (cartId = occCartId))
      .unsubscribe();

    this.checkoutConnector.processBillingAgreementExpressCheckout(userId, cartId)
      .pipe(takeWhile(paymentDetails => paymentDetails === undefined || paymentDetails.id === undefined, true))
      .subscribe(paymentDetails => {
        if (paymentDetails){
          this.multiCartService.reloadCart(cartId);
          this.checkoutService.loadCheckoutDetails(cartId);

          this.checkoutDetailsService.getPaymentDetails()
            .pipe(takeWhile(paymentDetails => paymentDetails === undefined, true))
            .subscribe(payment => {
              if (payment){
                this.router.navigate(['/checkout/review-order']);
              }
            });
        }
      });
  }

  public createOrder(
    fundingSource: string
  ): Observable<PaypalOrder> {
    let userId;
    this.userIdService
      .getUserId()
      .subscribe((occUserId) => (userId = occUserId))
      .unsubscribe();

    let cartId;
    this.activeCartService
      .getActiveCartId()
      .subscribe((activeCartId) => (cartId = activeCartId))
      .unsubscribe();

    return this.checkoutConnector.createOrder(cartId, userId, fundingSource);
  }

  public createBillingAgreementToken(
  ): Observable<PayPalBillingAgreementToken> {

    let userId;
    this.userIdService
      .getUserId()
      .subscribe((occUserId) => (userId = occUserId))
      .unsubscribe();

    let cartId;
    this.activeCartService
      .getActiveCartId()
      .subscribe((activeCartId) => (cartId = activeCartId))
      .unsubscribe();

    return this.checkoutConnector.createBillingAgreementToken(cartId, userId);
  }

  public createPayPalPaymentMethod(
    payPalPaymentRequest: PayPalPaymentRequest,
    fields?: Fields,
    paymentMethodType?: string
  ): Observable<PaymentDetails> {
    let userId;
    this.userIdService
      .getUserId()
      .subscribe((occUserId) => (userId = occUserId))
      .unsubscribe();

    let cartId;
    this.activeCartService
      .getActiveCartId()
      .subscribe((activeCartId) => (cartId = activeCartId))
      .unsubscribe();

    return this.checkoutConnector.createPayPalPaymentMethod(cartId, userId, payPalPaymentRequest, fields, paymentMethodType);
  }

  public createPayPalBillingAgreementPayment(
    payPalBillingAgreementPaymentRequest: PayPalBillingAgreementPaymentRequest,
    fields?: Fields,
    paymentMethodType?: string
  ): Observable<PaymentDetails> {
    let userId;
    this.userIdService
      .getUserId()
      .subscribe((occUserId) => (userId = occUserId))
      .unsubscribe();

    let cartId;
    this.activeCartService
      .getActiveCartId()
      .subscribe((activeCartId) => (cartId = activeCartId))
      .unsubscribe();

    return this.checkoutConnector.createPayPalBillingAgreementPayment(cartId, userId, payPalBillingAgreementPaymentRequest,
      fields, paymentMethodType);
  }

  setPaymentDetails(paymentDetails: PaymentDetails): void  {
    let userId;
    this.userIdService
      .getUserId()
      .subscribe((occUserId) => (userId = occUserId))
      .unsubscribe();

    let cartId;
    this.activeCartService
      .getActiveCartId()
      .subscribe((activeCartId) => (cartId = activeCartId))
      .unsubscribe();

    this.checkoutConnector.setPayPalPaymentMethod(userId, cartId, paymentDetails.id).subscribe( res => {
      console.log(res);
      console.log('selectPaymentMethod');
    });
  }

  public createPayPalPaymentAndAddAddressForNewUser(
    payPalBillingAgreementPaymentRequest: PayPalBillingAgreementPaymentRequest,
    accessToken: string,
    fields?: Fields,
    paymentMethodType?: string
  ): Observable<AddingPaymentMethodAndAddressStatusData> {
    let userId;
    this.userIdService
    .getUserId()
    .subscribe((occUserId) => (userId = occUserId))
    .unsubscribe();

    return this.connectConnector.savePaymentDetailsAndAddressForNewUser(payPalBillingAgreementPaymentRequest, accessToken, userId,
      fields, paymentMethodType);
  }

  public createBillingAgreementTokenWithoutCart(
  ): Observable<PayPalBillingAgreementToken> {
    let userId;
    this.userIdService
    .getUserId()
    .subscribe((occUserId) => (userId = occUserId))
    .unsubscribe();

    return this.connectConnector.createBillingAgreementTokenWithoutCart(userId);
  }



}
