import { Injectable } from '@angular/core';
import {
  ActiveCartService,
  CheckoutActions,
  CheckoutService,
  Occ,
  StateWithCheckout,
  StateWithProcess,
  UserIdService
} from '@spartacus/core';
import {Store} from '@ngrx/store';
import ScheduleReplenishmentForm = Occ.ScheduleReplenishmentForm;
import {take} from 'rxjs/operators';
import {PaypalCheckoutAction, PaypalReplenishmentOrderAction} from '../paypal-checkout-store/actions';


@Injectable({
  providedIn: 'root'
})
export class PaypalCheckoutService  extends CheckoutService{

  constructor(
    protected checkoutStore: Store<StateWithCheckout | StateWithProcess<void>>,
    protected activeCartService: ActiveCartService,
    protected userIdService: UserIdService
  ) {
    super(
      checkoutStore,
      activeCartService,
      userIdService
    )
  }

  scheduleReplenishmentOrder(
    scheduleReplenishmentForm: ScheduleReplenishmentForm,
    termsChecked: boolean
  ): void {

    let userId;
    this.userIdService
      .getUserId()
      .subscribe((occUserId) => (userId = occUserId))
      .unsubscribe();

    let cartId;
    this.activeCartService
      .getActiveCartId()
      .subscribe((activeCartId) => (cartId = activeCartId))
      .unsubscribe();

    if (userId && cartId) {
      this.checkoutStore.dispatch(
        new PaypalReplenishmentOrderAction.PaypalScheduleReplenishmentOrder({
          cartId,
          scheduleReplenishmentForm,
          termsChecked,
          userId,
        })
      );
    }
  }
}
