import { Injectable } from '@angular/core';
import {PaypalCheckoutDetailsConnector} from '../connectors/paypal-checkout-details.connector';
import {ActiveCartService, CheckoutPaymentService, Occ, StateWithCheckout, StateWithProcess, UserIdService} from '@spartacus/core';
import {Store} from '@ngrx/store';
import PaymentDetails = Occ.PaymentDetails;
import { PaypalCheckoutAction } from '../paypal-checkout-store/actions/index';

@Injectable({
  providedIn: 'root'
})
export class PaypalCheckoutPaymentService extends CheckoutPaymentService{

  constructor(
    protected checkoutStore: Store<StateWithCheckout | StateWithProcess<void>>,
    protected activeCartService: ActiveCartService,
    protected userIdService: UserIdService,
    protected checkoutConnector: PaypalCheckoutDetailsConnector,
  ) {
    super(
      checkoutStore,
      activeCartService,
      userIdService
    );
  }

  setPaymentDetails(paymentDetails: PaymentDetails): void  {
    let userId;
    this.userIdService
      .getUserId()
      .subscribe((occUserId) => (userId = occUserId))
      .unsubscribe();

    let cartId;
    this.activeCartService
      .getActiveCartId()
      .subscribe((activeCartId) => (cartId = activeCartId))
      .unsubscribe();

        if (userId && cartId) {
          this.checkoutStore.dispatch(
            new PaypalCheckoutAction.SetPaypalPaymentDetails({
              userId,
              cartId,
              paymentDetails: paymentDetails,
            })
          );
        }
  }

}

