import {PaypalCheckoutData} from '../models/paypal-payment-data.model';
import {Converter} from '@spartacus/core';
import {InjectionToken} from '@angular/core';
import {
  AddingPaymentMethodAndAddressStatusData,
  PayPalBillingAgreementPaymentForNewUserRequest,
  PayPalBillingAgreementPaymentRequest,
  PayPalButtonStyle, PayPalConnectB2BData,
  PayPalConnectB2BRegisterData,
  PayPalConnectData,
  PayPalConnectLoginData
} from '../models';
import {PayPalBillingAgreementToken, PaypalOrder, PayPalPaymentRequest} from '../models/paypa-checkout-data.model';

export const PAYPAL_PAYMENT_DETAILS_SERIALIZER = new InjectionToken<
  Converter<PayPalPaymentRequest, any>
  >('PayPalPaymentRequestSerializer');

export const  PAYPAL_BILLING_AGREEMENT_PAYMENT_SERIALIZER = new InjectionToken<
  Converter<PayPalBillingAgreementPaymentRequest, any>
  >('PayPalBillingAgreementPaymentRequestSerializer');

export const  PAYPAL_BILLING_AGREEMENT_PAYMENT_FOR_NEW_USER_SERIALIZER = new InjectionToken<
  Converter<PayPalBillingAgreementPaymentForNewUserRequest, any>
  >('PayPalBillingAgreementPaymentForNewUserRequestSerializer');

export const  PAYPAL_CONNECT_B2B_REGISTER_DATA_SERIALIZER = new InjectionToken<
  Converter<PayPalConnectB2BRegisterData, any>
  >('PayPalConnectB2BRegisterDataSerializer');

export const PAYPAL_CHECKOUT_DATA_NORMALIZER = new InjectionToken<
  Converter<any, PaypalCheckoutData>
  >('PaypalCheckoutDataNormalizer');

export const PAYPAL_BUTTON_STYLE_NORMALIZER = new InjectionToken<
  Converter<any, PayPalButtonStyle>
  >('PayPalButtonStyleNormalizer');

export const PAYPAL_ORDER_NORMALIZER = new InjectionToken<
  Converter<any, PaypalOrder>
  >('PayPalOrderNormalizer');

export const PAYPAL_BILLING_AGREEMENT_TOKEN_NORMALIZER = new InjectionToken<
  Converter<any, PayPalBillingAgreementToken>
  >('PayPalBillingAgreementTokenNormalizer');

export const PAYPAL_ADDING_PAYMENT_METHOD_AND_ADDRESS_STATUS_NORMALIZER = new InjectionToken<
  Converter<any, AddingPaymentMethodAndAddressStatusData>
  >('AddingPaymentMethodAndAddressStatusDataNormalizer');

export const PAYPAL_BOOLEAN_NORMALIZER = new InjectionToken<
  Converter<any, boolean>
  >('PayPalBooleanNormalizer');

export const PAYPAL_STRING_NORMALIZER = new InjectionToken<
  Converter<any, string>
  >('PayPalStringNormalizer');

export const PAYPAL_CONNECT_DATA_NORMALIZER = new InjectionToken<
  Converter<any, PayPalConnectData>
  >('PayPalConnectDataNormalizer');

export const PAYPAL_CONNECT_B2B_DATA_NORMALIZER = new InjectionToken<
  Converter<any, PayPalConnectB2BData>
  >('PayPalConnectB2BDataNormalizer');

export const PAYPAL_CONNECT_LOGIN_DATA_NORMALIZER = new InjectionToken<
  Converter<any, PayPalConnectLoginData>
  >('PayPalConnectLoginDataNormalizer');
