import {Injectable} from '@angular/core';
import {Observable} from 'rxjs';
import {PaymentAdapter} from './payment.adapter';
import {PaypalCheckoutData} from '../models/paypal-payment-data.model';
import {PayPalButtonStyle} from '../models';

@Injectable()
export class PaypalPaymentDetailsConnector {

  constructor(protected adapter: PaymentAdapter) {}

  loadPaymentDetails(
    pageType: string,
    userId: string,
  ): Observable<PaypalCheckoutData> {
    return this.adapter.loadCheckoutData(pageType, userId);
  }

  loadPaypalButtonStyles(
    pageType: string,
    userId: string
  ): Observable<PayPalButtonStyle>{
    return this.adapter.loadPaypalButtonStyles(pageType, userId);
  }
}
