import {Injectable} from '@angular/core';
import {Observable} from 'rxjs';
import {ConnectAdapter} from './connect.adapter';
import {
  AddingPaymentMethodAndAddressStatusData,
  Fields,
  PayPalBillingAgreementPaymentRequest,
  PayPalBillingAgreementToken,
  PayPalConnectB2BData,
  PayPalConnectB2BRegisterData,
  PayPalConnectData,
  PayPalConnectLoginData
} from '../models';

@Injectable()
export class PaypalConnectConnector {

  constructor(protected adapter: ConnectAdapter) {}

  exchangeAuthorizationCode(
    authorizationToken: string,
    userId: string,
  ): Observable<PayPalConnectData> {
    return this.adapter.exchangeAuthorizationCode(authorizationToken, userId);
  }

  login(
    accessToken: string,
    userId: string
  ): Observable<PayPalConnectLoginData> {
    return this.adapter.login(accessToken, userId);
  }

  afterLogin(
    accessToken: string,
    userId: string
  ): Observable<boolean> {
    return this.adapter.afterLogin(accessToken, userId);
  }

  register(
    accessToken: string,
    userId: string
  ): Observable<string> {
    return this.adapter.register(accessToken, userId);
  }

  exchangeAuthorizationCodeB2B(
    authorizationToken: string,
    userId: string
  ): Observable<PayPalConnectB2BData> {
    return this.adapter.exchangeAuthorizationCodeB2B(authorizationToken, userId);
  }

  registerB2BCustomer(
    accessToken: string,
    registerData: PayPalConnectB2BRegisterData,
    userId: string
  ): Observable<string> {
    return this.adapter.registerB2BCustomer(accessToken,registerData, userId);
  }

  savePaymentDetailsAndAddressForNewUser(
    payPalBillingAgreementPaymentRequest: PayPalBillingAgreementPaymentRequest,
    accessToken: string,
    userId: string,
    fields?: Fields,
    paymentMethodType?: string
  ): Observable<AddingPaymentMethodAndAddressStatusData> {
    return this.adapter.savePaymentDetailsAndAddressForNewUser(payPalBillingAgreementPaymentRequest, accessToken, userId, fields, paymentMethodType);
  }

  createBillingAgreementTokenWithoutCart(
    userId: string
  ): Observable<PayPalBillingAgreementToken> {
    return this.adapter.createBillingAgreementTokenWithoutCart(userId);
  }

}
