import {Injectable} from '@angular/core';
import {CheckoutAdapter} from './checkout.adapter';
import {Observable} from 'rxjs';
import {
  PayPalBillingAgreementPaymentRequest,
  PayPalBillingAgreementToken,
  PaypalOrder,
  PayPalPaymentRequest
} from '../models/paypa-checkout-data.model';
import {Fields} from '../models';
import {PaymentDetails} from '@spartacus/core';

@Injectable()
export class PaypalCheckoutDetailsConnector {

  constructor(
    protected checkoutAdapter: CheckoutAdapter
  ) {
  }

  createOrder(
    cartId: string,
    userId: string,
    fundingSource: string
  ): Observable<PaypalOrder> {
    return this.checkoutAdapter.createOrder(cartId, userId, fundingSource);
  }


  createBillingAgreementToken(
    cartId: string,
    userId: string
  ): Observable<PayPalBillingAgreementToken> {
    return this.checkoutAdapter.createBillingAgreementToken(cartId, userId);
  }

  createPayPalPaymentMethod(
    cartId: string,
    userId: string,
    payPalPaymentRequest: PayPalPaymentRequest,
    fields?: Fields,
    paymentMethodType?: string
  ): Observable<PaymentDetails> {
    return this.checkoutAdapter.createPayPalPaymentMethod(cartId, userId, payPalPaymentRequest, fields, paymentMethodType);
  }

  createPayPalBillingAgreementPayment(
    cartId: string,
    userId: string,
    payPalBillingAgreementPaymentRequest: PayPalBillingAgreementPaymentRequest,
    fields?: Fields,
    paymentMethodType?: string
  ): Observable<PaymentDetails> {
    return this.checkoutAdapter.createPayPalBillingAgreementPayment(cartId, userId, payPalBillingAgreementPaymentRequest,
      fields, paymentMethodType);
  }

  public setPayPalPaymentMethod(
    userId: string,
    cartId: string,
    paymentDetailsId: string
  ): Observable<any> {
    return this.checkoutAdapter.setPayPalPaymentMethod(userId, cartId, paymentDetailsId);
  }

  processBillingAgreementExpressCheckout(userId, cartId) {
    return this.checkoutAdapter.processBillingAgreementExpressCheckout(userId, cartId);
  }
}
