import {Observable} from 'rxjs';
import {
  AddingPaymentMethodAndAddressStatusData,
  Fields,
  PayPalBillingAgreementPaymentRequest, PayPalBillingAgreementToken,
  PayPalConnectB2BData,
  PayPalConnectB2BRegisterData,
  PayPalConnectData,
  PayPalConnectLoginData
} from '../models';
import {PaymentDetails} from '@spartacus/core';

export abstract class ConnectAdapter {

  abstract exchangeAuthorizationCode(
    authorizationToken: string,
    userId: string
  ): Observable<PayPalConnectData>;

  abstract login(
    accessToken: string,
    userId: string
  ): Observable<PayPalConnectLoginData>;

  abstract afterLogin(
    accessToken: string,
    userId: string
  ): Observable<boolean>

  abstract register(
    accessToken: string,
    userId: string
  ): Observable<string>;

  abstract exchangeAuthorizationCodeB2B(
    authorizationToken: string,
    userId: string
  ): Observable<PayPalConnectB2BData>;

  abstract registerB2BCustomer(
    accessToken: string,
    registerData: PayPalConnectB2BRegisterData,
    userId: string
  ): Observable<string>;

  abstract savePaymentDetailsAndAddressForNewUser(
    payPalBillingAgreementPaymentRequest: PayPalBillingAgreementPaymentRequest,
    accessToken: string,
    userId: string,
    fields?: Fields,
    paymentMethodType?: string
  ): Observable<AddingPaymentMethodAndAddressStatusData>;

  abstract createBillingAgreementTokenWithoutCart(
    userId: string
  ): Observable<PayPalBillingAgreementToken>

}
