import {Observable} from 'rxjs';
import {
  PayPalBillingAgreementPaymentRequest,
  PayPalBillingAgreementToken,
  PaypalOrder,
  PayPalPaymentRequest
} from '../models/paypa-checkout-data.model';
import {Fields} from '../models';
import {PaymentDetails} from '@spartacus/core';

export abstract class CheckoutAdapter {

  abstract createOrder(
    cartId: string,
    userId: string,
    fundingSource: string
  ): Observable<PaypalOrder>;

  abstract createBillingAgreementToken(
    cartId: string,
    userId: string
  ): Observable<PayPalBillingAgreementToken>;

  abstract createPayPalPaymentMethod(
    cartId: string,
    userId: string,
    payPalPaymentRequest: PayPalPaymentRequest,
    fields?: Fields,
    paymentMethodType?: string
  ): Observable<PaymentDetails>;

  abstract createPayPalBillingAgreementPayment(
    cartId: string,
    userId: string,
    payPalBillingAgreementPaymentRequest: PayPalBillingAgreementPaymentRequest,
    fields?: Fields,
    paymentMethodType?: string
  ): Observable<PaymentDetails>;

  abstract setPayPalPaymentMethod(
    userId: string,
    cartId: string,
    paymentDetailsId: string
  ): Observable<any>;

  abstract processBillingAgreementExpressCheckout(
    userId: string,
    cartId: string
  ): Observable<PaymentDetails>;

}
