package com.braintree.facades.impl;

import com.braintree.data.UserData;
import com.braintree.dto.TestMapWsDTO;
import com.braintree.services.BraintreeSampleUserServices;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.user.UserModel;
import de.hybris.platform.core.servicelayer.data.PaginationData;
import de.hybris.platform.core.servicelayer.data.SearchPageData;
import de.hybris.platform.servicelayer.dto.converter.Converter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

import static com.braintree.constants.BraintreewebserviceConstants.SAMPLE_MAP_INTEGER_KEY;
import static com.braintree.constants.BraintreewebserviceConstants.SAMPLE_MAP_INTEGER_VALUE;
import static com.braintree.constants.BraintreewebserviceConstants.SAMPLE_MAP_STRING_KEY;
import static com.braintree.constants.BraintreewebserviceConstants.SAMPLE_MAP_STRING_VALUE;


import static org.hamcrest.Matchers.instanceOf;
import static org.mockito.Mockito.when;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.times;


@UnitTest
public class DefaultBraintreeSampleFacadesTest {
    @InjectMocks
    DefaultBraintreeSampleFacades defaultBraintreeSampleFacades;

    @Mock
    BraintreeSampleUserServices braintreeSampleUserServices;

    @Mock
    Converter<UserModel, UserData> userConverter;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void getUsersShouldReturnPageData() {
        SearchPageData<?> params = Mockito.mock(SearchPageData.class);
        PaginationData paginationData = Mockito.mock(PaginationData.class);

        when(params.getPagination()).thenReturn(paginationData);
        when(paginationData.getPageSize()).thenReturn(20);

        Assert.assertThat(defaultBraintreeSampleFacades.getUsers(params), instanceOf(SearchPageData.class));
        verify(params).getPagination();
        verify(paginationData, times(3)).getPageSize();
    }

    @Test
    public void getMapShouldReturnProperlyInitializedMap() {
        TestMapWsDTO result = defaultBraintreeSampleFacades.getMap();

        Assert.assertThat(result, instanceOf(TestMapWsDTO.class));
        Assert.assertEquals(SAMPLE_MAP_INTEGER_VALUE, (int) result.getIntegerMap().get(SAMPLE_MAP_INTEGER_KEY));
        Assert.assertEquals(SAMPLE_MAP_STRING_VALUE, result.getStringMap().get(SAMPLE_MAP_STRING_KEY));
    }

    @Test
    public void getUsersShouldReturnNullWhenWrongIdPassed() {
        Assert.assertNull(defaultBraintreeSampleFacades.getUser("mockId"));
    }

    @Test
    public void getUsersShouldReturnUserData() {
        UserModel userModel = Mockito.mock(UserModel.class);
        UserData userData = Mockito.mock(UserData.class);

        when(braintreeSampleUserServices.getUserById("1")).thenReturn(userModel);
        when(userConverter.convert(userModel)).thenReturn(userData);

        Assert.assertThat(defaultBraintreeSampleFacades.getUser("1"), instanceOf(UserData.class));
    }
}
