/*

 */
package com.braintree.setup.impl;

import de.hybris.platform.addonsupport.setup.impl.DefaultAddonSampleDataImportService;
import de.hybris.platform.core.initialization.SystemSetupContext;
import java.util.ArrayList;
import java.util.List;

/**
 * This class extends DefaultAddonSampleDataImportService and override importContentCatalog method
 */
public class BraintreeSpaSampleDataImportService extends DefaultAddonSampleDataImportService
{
    List<String> catalogs;

    /**
     * Default constructor
     */
    public BraintreeSpaSampleDataImportService() {
        catalogs=new ArrayList<>();
        catalogs.add("electronics");
        catalogs.add("apparel-uk");
        catalogs.add("powertools");
        catalogs.add("electronics-spa");
        catalogs.add("apparel-uk-spa");
        catalogs.add("powertools-spa");

    }

    @Override
    protected void importContentCatalog(SystemSetupContext context, String importRoot, String catalogName)
    {
        if (catalogs.contains(catalogName))
        {
            importImpexFile(context, importRoot + "/contentCatalogs/" + catalogName + "ContentCatalog/cms-content.impex", false);
            importImpexFile(context, importRoot + "/contentCatalogs/" + catalogName + "ContentCatalog/email-content.impex", false);
            synchronizeContentCatalog(context, catalogName + "-spa", true);
        }
    }
}
