package braintreehac.services;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.catalog.CatalogVersionService;
import de.hybris.platform.catalog.model.CatalogModel;
import de.hybris.platform.catalog.model.CatalogVersionModel;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.model.contents.components.SimpleCMSComponentModel;
import de.hybris.platform.cms2.model.site.CMSSiteModel;
import de.hybris.platform.cms2.servicelayer.services.CMSComponentService;
import de.hybris.platform.cms2.servicelayer.services.CMSSiteService;
import de.hybris.platform.cms2.servicelayer.services.admin.CMSAdminSiteService;
import de.hybris.platform.cmsfacades.cmsitems.CMSItemFacade;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static org.mockito.Mockito.*;

@UnitTest
public class BraintreeConnectWithPayPalButtonConfigurationsServiceTest {

    @InjectMocks
    BraintreeConnectWithPayPalButtonConfigurationsService payPalComponentConfigurationService;

    @Mock
    CMSComponentService cmsComponentService;

    @Mock
    CMSItemFacade cmsItemFacade;

    @Mock
    CMSSiteService cmsSiteService;

    @Mock
    CatalogModel mockCatalogModel;

    @Mock
    CatalogVersionModel mockCatalogVersionModel;

    @Mock
    CatalogVersionService catalogVersionService;

    @Mock
    BrainTreeCatalogSynchronizationService BrainTreeCatalogSynchronizationService;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void processComponentUpdatingShouldProcessSuccessfully() throws CMSItemNotFoundException {
        SimpleCMSComponentModel mockSimpleCMSComponentModel = Mockito.mock(SimpleCMSComponentModel.class);
        CatalogVersionModel mockCatalogVersionModel = Mockito.mock(CatalogVersionModel.class);
        CatalogModel mockCatalogModel = Mockito.mock(CatalogModel.class);
        CatalogVersionService mockCatalogVersionService = Mockito.mock(CatalogVersionService.class);
        CMSAdminSiteService mockCMSAdminSiteService = Mockito.mock(CMSAdminSiteService.class);
        SimpleCMSComponentModel mockComponentByUid = Mockito.mock(SimpleCMSComponentModel.class);

        payPalComponentConfigurationService.setCatalogVersionService(mockCatalogVersionService);
        payPalComponentConfigurationService.setCmsAdminSiteService(mockCMSAdminSiteService);

        Map<String, Object> mockPayPalCreditMessageComponent = Map.of("mockKey", "mockVal");
        Map<String, String[]> mockRefreshedParameters = Map.of("uuid", new String[]{"mockValue"});

        when(cmsComponentService.getSimpleCMSComponent("mockUid")).thenReturn(mockSimpleCMSComponentModel);
        when(cmsComponentService.getSimpleCMSComponent("mockUid" + "B2B")).thenReturn(mockSimpleCMSComponentModel);
        when(cmsComponentService.getSimpleCMSComponent("mockUid" + "SPA")).thenReturn(mockSimpleCMSComponentModel);
        when(mockSimpleCMSComponentModel.getCatalogVersion()).thenReturn(mockCatalogVersionModel);
        when(mockCatalogVersionModel.getCatalog()).thenReturn(mockCatalogModel);
        when(mockCatalogModel.getId()).thenReturn("28");
        when(mockCatalogVersionService.getCatalogVersion("28", "Staged")).thenReturn(mockCatalogVersionModel);
        when(cmsItemFacade.getCMSItemByUuid("mockUid")).thenReturn(mockPayPalCreditMessageComponent);
        when(mockComponentByUid.getUid()).thenReturn("mockUid");
        when(mockCMSAdminSiteService.getActiveCatalogVersion()).thenReturn(mockCatalogVersionModel);

        payPalComponentConfigurationService.processComponentUpdating("mockUid", mockRefreshedParameters);

        verify(mockSimpleCMSComponentModel, times(3)).getCatalogVersion();
        verify(mockCatalogVersionModel, times(6)).getCatalog();
        verify(cmsComponentService, times(1)).getSimpleCMSComponent("mockUid");
        verify(cmsComponentService, times(1)).getSimpleCMSComponent("mockUid" + "B2B");
        verify(cmsComponentService, times(1)).getSimpleCMSComponent("mockUid" + "SPA");
    }

    @Test
    public void processNormalRequestShouldReturnTrue() {
        CMSSiteModel mockCMSSiteModel = Mockito.mock(CMSSiteModel.class);

        ArrayList<CMSSiteModel> mockSiteArr = new ArrayList<>(List.of(mockCMSSiteModel));
        ArrayList<CatalogModel> mockCatalogArr = new ArrayList<>(List.of(mockCatalogModel));

        when(cmsSiteService.getSites()).thenReturn(mockSiteArr);
        when(cmsSiteService.getAllCatalogs(mockCMSSiteModel)).thenReturn(mockCatalogArr);
        when(mockCatalogModel.getActiveCatalogVersion()).thenReturn(mockCatalogVersionModel);

        Assert.assertTrue(payPalComponentConfigurationService.processNormalRequest());
    }

    @Test
    public void getComponentByUidShouldCatchItemNotFoundException() throws CMSItemNotFoundException {
        when(cmsComponentService.getSimpleCMSComponent("mockUid")).thenThrow(CMSItemNotFoundException.class);

        Assert.assertNull(payPalComponentConfigurationService.getComponentByUid("mockUid"));
    }

    @Test
    public void getTargetCatalogVersionShouldChangeVersionName() {
        when(mockCatalogVersionModel.getCatalog()).thenReturn(mockCatalogModel);
        when(mockCatalogModel.getId()).thenReturn("28");
        when(mockCatalogVersionModel.getVersion()).thenReturn("Online");

        payPalComponentConfigurationService.getTargetCatalogVersion(mockCatalogVersionModel);

        verify(mockCatalogVersionModel, times(1)).getCatalog();
        verify(mockCatalogModel, times(1)).getId();
    }
}
