/**
 *
 */
package de.hybris.platform.hac.controller;


import braintreehac.services.BrainTreeDropInConfigurationService;
import de.hybris.platform.braintreehac.data.ApplePayDropInButtonStyleData;
import de.hybris.platform.braintreehac.data.GooglePayDropInButtonStyleData;
import de.hybris.platform.braintreehac.data.PayPalDropInButtonStyleData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import static braintreehac.services.BrainTreeDropInConfigurationService.*;


@Controller
@RequestMapping("/braintreehac")
public class BraintreeDropInConfigurationController {

    private static final String LABEL = "pageLabel";
    private static final String DROP_IN_PAYPAL_CONFIG_PAGE = "dropInPayPalConfig";
    private static final String DROP_IN_GOOGLE_PAY_CONFIG_PAGE = "dropInGooglePayConfig";
    private static final String DROP_IN_APPLE_PAY_CONFIG_PAGE = "dropInApplePayConfig";
    private static final String REDIRECT_PREFIX = "redirect:";
    private static final String PLACING_PARAMETER = "?placing=";
    private static final String REDIRECTION_TO_DROP_IN_CONFIG_PAYPAL = "/braintreehac/dropIn/config/payPal";
    private static final String REDIRECTION_TO_DROP_IN_CONFIG_GOOGLE_PAY = "/braintreehac/dropIn/config/googlePay";
    private static final String REDIRECTION_TO_DROP_IN_CONFIG_APPLE_PAY = "/braintreehac/dropIn/config/applePay";
    private static final String PLACING_FROM_CONTROLLER = "placingFromController";
    private static final String DROP_IN_COMPONENT = "dropInComponent";
    private static final String PLACING_DROP_IN = "placingDropIn";
    private static final String DEFAULT_DROP_IN_GOOGLE_PAY_COLOR = "default";

    @Autowired
    private BrainTreeDropInConfigurationService dropInConfigurationService;

    @RequestMapping(value = "/dropIn/config/payPal", method = RequestMethod.GET)
    public String payPalDropInButtonConfig(HttpServletRequest request, HttpServletResponse response,
                                                     @RequestParam(required = false, defaultValue = CART)
                                                     final String placing, ModelMap model) {
        final PayPalDropInButtonStyleData buttonStyleData =
                dropInConfigurationService.parsingJsonStringIntoPayPalDropInButtonStyleData(PAYPAL, placing);
        model.addAttribute(LABEL, "Drop-in UI PayPal Button configuration");
        model.addAttribute(PLACING_FROM_CONTROLLER, placing);
        model.addAttribute(DROP_IN_COMPONENT, buttonStyleData);
        model.addAttribute(PLACING_DROP_IN, dropInConfigurationService.getAllPlacingDropIn());
        model.addAttribute("color", dropInConfigurationService.getAllPayPalDropInColor());
        model.addAttribute("shape", dropInConfigurationService.getAllPayPalDropInShape());
        model.addAttribute("label", dropInConfigurationService.getAllPayPalDropInLabel());
        model.addAttribute("layout", dropInConfigurationService.getAllPayPalDropInLayout());
        return DROP_IN_PAYPAL_CONFIG_PAGE;
    }

    @RequestMapping(value = "/dropIn/config/payPal/save", method = RequestMethod.GET)
    public String savePayPalDropInButtonConfig(HttpServletRequest request,  HttpServletResponse response,
                                                @RequestParam(required = false, defaultValue = CART)
                                                final String placing, ModelMap model) {
        final PayPalDropInButtonStyleData buttonStyleData = dropInConfigurationService.createPayPalDropInButtonStyleData(
                request.getParameter("color"), request.getParameter("shape"), request.getParameter("label"),
                request.getParameter("layout"), Boolean.parseBoolean(request.getParameter("tagline")));
        dropInConfigurationService.updateStylePayPalDropInButtonStyleData(PAYPAL, placing, buttonStyleData);
        return REDIRECT_PREFIX + REDIRECTION_TO_DROP_IN_CONFIG_PAYPAL + PLACING_PARAMETER + placing;
    }


    @RequestMapping(value = "/dropIn/config/googlePay", method = RequestMethod.GET)
    public String googlePayDropInButtonConfig(HttpServletRequest request, HttpServletResponse response,
                                                        @RequestParam(required = false, defaultValue = CART)
                                                        final String placing, ModelMap model) {
        GooglePayDropInButtonStyleData buttonStyleData =
                dropInConfigurationService.parsingJsonStringIntoGooglePayDropInButtonStyleData(GOOGLE_PAY, placing);
        model.addAttribute(LABEL, "Drop-in UI Google Pay Button configuration");
        model.addAttribute(PLACING_FROM_CONTROLLER, placing);
        model.addAttribute(DROP_IN_COMPONENT, buttonStyleData);
        model.addAttribute(PLACING_DROP_IN, dropInConfigurationService.getAllPlacingDropIn());
        model.addAttribute("buttonColor", dropInConfigurationService.getAllGooglePayDropInColor());
        model.addAttribute("buttonType", dropInConfigurationService.getAllGooglePayDropInType());
        model.addAttribute("buttonSizeMode", dropInConfigurationService.getAllGooglePayDropInSizeMode());
        return DROP_IN_GOOGLE_PAY_CONFIG_PAGE;
    }

    @RequestMapping(value = "/dropIn/config/googlePay/save", method = RequestMethod.GET)
    public String saveGooglePayDropInButtonConfig(HttpServletRequest request,  HttpServletResponse response,
                                                @RequestParam(required = false, defaultValue = CART)
                                                final String placing, ModelMap model) {
        final GooglePayDropInButtonStyleData buttonStyleData =
                dropInConfigurationService.createGooglePayDropInButtonStyleData(DEFAULT_DROP_IN_GOOGLE_PAY_COLOR,
                        request.getParameter("buttonType"), request.getParameter("buttonSizeMode"));
        dropInConfigurationService.updateStyleGooglePayDropInButtonStyleData(GOOGLE_PAY, placing, buttonStyleData);
        return REDIRECT_PREFIX + REDIRECTION_TO_DROP_IN_CONFIG_GOOGLE_PAY + PLACING_PARAMETER + placing;
    }


    @RequestMapping(value = "/dropIn/config/applePay", method = RequestMethod.GET)
    public String applePayDropInButtonConfig(HttpServletRequest request, HttpServletResponse response,
                                                        @RequestParam(required = false, defaultValue = CART)
                                                        final String placing, ModelMap model) {
        final ApplePayDropInButtonStyleData buttonStyleData =
                dropInConfigurationService.parsingJsonStringIntoApplePayDropInButtonStyleData(APPLE_PAY, placing);
        model.addAttribute(LABEL, "Drop-in UI Apple Pay Button configuration");
        model.addAttribute(PLACING_FROM_CONTROLLER, placing);
        model.addAttribute(DROP_IN_COMPONENT, buttonStyleData);
        model.addAttribute(PLACING_DROP_IN, dropInConfigurationService.getAllPlacingDropIn());
        model.addAttribute("buttonStyle", dropInConfigurationService.getAllApplePayDropInButtonStyle());

        return DROP_IN_APPLE_PAY_CONFIG_PAGE;
    }

    @RequestMapping(value = "/dropIn/config/applePay/save", method = RequestMethod.GET)
    public String saveApplePayDropInButtonConfig(HttpServletRequest request,  HttpServletResponse response,
                                                  @RequestParam(required = false, defaultValue = CART)
                                                  final String placing, ModelMap model) {
        final ApplePayDropInButtonStyleData buttonStyleData =
                dropInConfigurationService.createApplePayDropInButtonStyleData(request.getParameter("buttonStyle"));
        dropInConfigurationService.updateStyleApplePayDropInButtonStyleData(APPLE_PAY, placing, buttonStyleData);
        return REDIRECT_PREFIX + REDIRECTION_TO_DROP_IN_CONFIG_APPLE_PAY + PLACING_PARAMETER + placing;
    }

}
