package de.hybris.platform.hac.controller;

import braintreehac.services.BraintreeConnectWithPayPalButtonConfigurationsService;
import com.braintree.configuration.service.BrainTreeConfigService;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.model.contents.components.SimpleCMSComponentModel;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;


@Controller
@RequestMapping("/braintreehac")
public class BraintreeConnectWithPayPalButtonConfigurationsController {

    private static final String REDIRECT_PREFIX = "redirect:";
    private static final String CONNECT_WITH_PAYPAL = "PayPalConnectButtonComponent";
    private static final String CONNECT_WITH_PAYPAL_B2B = "PayPalConnectButtonComponentB2B";
    private static final String CONNECT_WITH_PAYPAL_HAC_JSP = "connectWithPayPalConfig";
    private static final String PAYPAL_CONNECT = "payPalConnect";
    private static final String COMPONENT_UID = "componentUid";
    private static final String BUTTON_TYPE = "buttonType";
    private static final String BUTTON_SHAPE = "buttonShape";
    private static final String BUTTON_SIZE = "buttonSize";
    private static final String BUTTON_THEME = "buttonTheme";
    private static final String UID = "uid";
    private static final String CONNECT_WITH_PAYPAL_STYLE_URL = "/braintreehac/connectWithPayPalConfigurations";
    private static final String PAYPAL_CONNECT_SCRIPT = "payPalConnectScript";
    private static final String PAYPAL_CONNECT_SCOPES = "payPalConnectScopes";
    private static final String PAYPAL_CONNECT_RESPONSE_TYPE = "payPalConnectResponseType";
    private static final String PAYPAL_ENV_CONFIGURATION = "environmentType";

    @Resource(name = "brainTreeConfigService")
    private BrainTreeConfigService brainTreeConfigService;

    @Resource(name = "braintreeConnectWithPayPalButtonConfigurationsService")
    private BraintreeConnectWithPayPalButtonConfigurationsService configurationsService;

    @RequestMapping(value = "/connectWithPayPalConfigurations", method = RequestMethod.GET)
    public String getConnectWithPayPalConfigurations(ModelMap model) throws CMSItemNotFoundException {

        configurationsService.processNormalRequest();

        SimpleCMSComponentModel payPalConnectComponent = configurationsService.getComponentByUid(CONNECT_WITH_PAYPAL);
        if (payPalConnectComponent == null) {
            payPalConnectComponent = configurationsService.getComponentByUid(CONNECT_WITH_PAYPAL_B2B);
        }

        model.addAttribute(PAYPAL_CONNECT, configurationsService.getPayPalConnectItemByUid(payPalConnectComponent));
        model.addAttribute(COMPONENT_UID, CONNECT_WITH_PAYPAL);
        setEssentialValues(model);
        addBrainTreeConnectWithPayPalConfigurations(model);
        return CONNECT_WITH_PAYPAL_HAC_JSP;
    }

    @RequestMapping(value = "/connectWithPayPalConfigurations/save", method = RequestMethod.POST)
    public String saveConnectWithPayPalConfigurations(HttpServletRequest request) {

        Map<String, String[]> refreshedParameters = new HashMap<>(request.getParameterMap());
        final String payPalConnectComponentUid = Arrays.stream(refreshedParameters.get(UID)).findFirst().get();
        refreshedParameters.remove(UID);
        configurationsService.processComponentUpdating(payPalConnectComponentUid, refreshedParameters);
        return REDIRECT_PREFIX + CONNECT_WITH_PAYPAL_STYLE_URL;
    }

    private void setEssentialValues(ModelMap model) {
        model.addAttribute(BUTTON_TYPE, Arrays.asList("LWP", "CWP"));
        model.addAttribute(BUTTON_SHAPE, Arrays.asList("PILL", "RECT"));
        model.addAttribute(BUTTON_SIZE, Arrays.asList("SM", "MD", "LG"));
        model.addAttribute(BUTTON_THEME, Arrays.asList("BLUE", "NEUTRAL"));
    }

    private void addBrainTreeConnectWithPayPalConfigurations(ModelMap model) {
        model.addAttribute(PAYPAL_CONNECT_SCRIPT, brainTreeConfigService.getPayPalConnectScript());
        model.addAttribute(PAYPAL_CONNECT_SCOPES, brainTreeConfigService.getPayPalConnectScopes());
        model.addAttribute(PAYPAL_CONNECT_RESPONSE_TYPE, brainTreeConfigService.getPayPalConnectResponseType());
        model.addAttribute(PAYPAL_ENV_CONFIGURATION, brainTreeConfigService.getEnvironmentType());
    }
}