package de.hybris.platform.hac.controller;

import de.hybris.platform.braintreehac.data.GooglePayButtonStyleData;
import de.hybris.platform.braintreehac.data.PayPalButtonStyleData;
import de.hybris.platform.braintreehac.data.ApplePayButtonStyleData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import braintreehac.services.BrainTreeButtonConfigurationService;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;


@Controller
@RequestMapping("/braintreehac")
public class BraintreeButtonConfigurationController {
    private static final String REDIRECT_PREFIX = "redirect:";
    private static final String PAYPAL_BUTTON_STYLE_CONFIG_ENDPOINT = "/braintreehac/button/config/payPal";
    private static final String GOOGLE_PAY_BUTTON_STYLE_CONFIG_ENDPOINT = "/braintreehac/button/config/googlePay";
    private static final String LOCATION_PARAMETER = "?location=";
    private static final String PAYPAL_CART_BUTTON_CONFIG = "payPal.cart.button.config";
    private static final String PAYPAL_MINI_CART_BUTTON_CONFIG = "payPal.mini.cart.button.config";
    private static final String PAYPAL_MARK_BUTTON_CONFIG = "payPal.mark.button.config";
    private static final String GOOGLE_PAY_CART_BUTTON_CONFIG = "google.pay.cart.button.config";
    private static final String GOOGLE_PAY_MINI_CART_BUTTON_CONFIG = "google.pay.mini.cart.button.config";
    private static final String GOOGLE_PAY_MARK_BUTTON_CONFIG = "google.pay.mark.button.config";
    private static final String APPLE_PAY_CART_BUTTON_CONFIG = "apple.pay.cart.button.config";
    private static final String APPLE_PAY_MINI_CART_BUTTON_CONFIG = "apple.pay.mini.cart.button.config";
    private static final String APPLE_PAY_MARK_BUTTON_CONFIG = "apple.pay.mark.button.config";
    private static final String PAYPAL_COMPONENT = "payPalComponent";
    private static final String GOOGLE_PAY_COMPONENT = "googlePayComponent";
    private static final String APPLE_PAY_COMPONENT = "applePayComponent";
    private static final String PAYPAL_BUTTON_CONFIG_PAGE = "payPalButtonConfig";
    private static final String GOOGLE_PAY_BUTTON_CONFIG_PAGE = "googlePayButtonConfig";
    private static final String LABEL = "pageLabel";
    private static final String CART = "cart";
    private static final String MINICART = "minicart";
    private static final String BILLING = "billing";
    private static final String LOCATION = "locationFromController";
    private static final String BUTTON_CONFIG = "buttonConfig";

    @Autowired
    private BrainTreeButtonConfigurationService payPalButtonConfigurationService;

    @RequestMapping(value = "/button/config/payPal", method = RequestMethod.GET)
    public String getPayPalButtonConfigPage(HttpServletRequest request, HttpServletResponse response,
                                            @RequestParam(required = false, defaultValue = CART) final String location, ModelMap model) {
        PayPalButtonStyleData payPalButtonConfig = null;

        switch (location) {
            case CART:
                payPalButtonConfig = payPalButtonConfigurationService.parsingJsonStringIntoPayPalButtonConfigData(PAYPAL_CART_BUTTON_CONFIG);
                model.addAttribute(BUTTON_CONFIG, PAYPAL_CART_BUTTON_CONFIG);
                break;
            case MINICART:
                payPalButtonConfig = payPalButtonConfigurationService.parsingJsonStringIntoPayPalButtonConfigData(PAYPAL_MINI_CART_BUTTON_CONFIG);
                model.addAttribute(BUTTON_CONFIG, PAYPAL_MINI_CART_BUTTON_CONFIG);
                break;
            case BILLING:
                payPalButtonConfig = payPalButtonConfigurationService.parsingJsonStringIntoPayPalButtonConfigData(PAYPAL_MARK_BUTTON_CONFIG);
                model.addAttribute(BUTTON_CONFIG, PAYPAL_MARK_BUTTON_CONFIG);
                break;
        }

        setEssentialValues(model);
        model.addAttribute(LOCATION, location);
        model.addAttribute(LABEL, "PayPal Page Smart Button configuration");
        model.addAttribute(PAYPAL_COMPONENT, payPalButtonConfig);

        return PAYPAL_BUTTON_CONFIG_PAGE;
    }

    @RequestMapping(value = "/button/config/payPal/save", method = RequestMethod.GET)
    public String saveAllButtonsConfig(HttpServletRequest request, HttpServletResponse response,
                                       @RequestParam(required = false, defaultValue = CART) final String location, ModelMap model) {
        final String buttonConfig = request.getParameter(BUTTON_CONFIG);
        payPalButtonConfigurationService.handlePayPalStyleDataUpdate(request, buttonConfig);

        return REDIRECT_PREFIX + PAYPAL_BUTTON_STYLE_CONFIG_ENDPOINT + LOCATION_PARAMETER + location;
    }

    @RequestMapping(value = "/button/config/googlePay", method = RequestMethod.GET)
    public String googlePayButtonConfig(HttpServletRequest request, HttpServletResponse response,
                                        @RequestParam(required = false, defaultValue = CART)
                                        final String location, ModelMap model) {
        GooglePayButtonStyleData googlePayButtonConfig = null;

        switch (location) {
            case CART:
                googlePayButtonConfig = payPalButtonConfigurationService.parsingJsonStringIntoGooglePayButtonConfigData(GOOGLE_PAY_CART_BUTTON_CONFIG);
                model.addAttribute(BUTTON_CONFIG, GOOGLE_PAY_CART_BUTTON_CONFIG);
                break;
            case MINICART:
                googlePayButtonConfig = payPalButtonConfigurationService.parsingJsonStringIntoGooglePayButtonConfigData(GOOGLE_PAY_MINI_CART_BUTTON_CONFIG);
                model.addAttribute(BUTTON_CONFIG, GOOGLE_PAY_MINI_CART_BUTTON_CONFIG);
                break;
            case BILLING:
                googlePayButtonConfig = payPalButtonConfigurationService.parsingJsonStringIntoGooglePayButtonConfigData(GOOGLE_PAY_MARK_BUTTON_CONFIG);
                model.addAttribute(BUTTON_CONFIG, GOOGLE_PAY_MARK_BUTTON_CONFIG);
                break;
        }

        setEssentialValuesForGooglePayButton(model);
        model.addAttribute(LOCATION, location);
        model.addAttribute(LABEL, "GooglePay Page Smart Button configuration");
        model.addAttribute(GOOGLE_PAY_COMPONENT, googlePayButtonConfig);
        return GOOGLE_PAY_BUTTON_CONFIG_PAGE;
    }

    @RequestMapping(value = "/button/config/googlePay/save", method = RequestMethod.GET)
    public String saveGooglePayDropInButtonConfig(HttpServletRequest request,  HttpServletResponse response,
                                                  @RequestParam(required = false, defaultValue = CART)
                                                  final String location, ModelMap model) {
        final String buttonConfig = request.getParameter(BUTTON_CONFIG);
        payPalButtonConfigurationService.handleGooglePayStyleDataUpdate(request, buttonConfig);

        return REDIRECT_PREFIX + GOOGLE_PAY_BUTTON_STYLE_CONFIG_ENDPOINT + LOCATION_PARAMETER + location;
    }

    @RequestMapping(value = "/button/config/applePay", method = RequestMethod.GET)
    public String applePayButtonConfig(HttpServletRequest request, HttpServletResponse response,
                                       @RequestParam(required = false, defaultValue = "cart")
                                       final String location, ModelMap model) {
        ApplePayButtonStyleData applePayButtonConfig = null;

        switch (location) {
            case CART:
                applePayButtonConfig = payPalButtonConfigurationService.parsingJsonStringIntoApplePayButtonConfigData(APPLE_PAY_CART_BUTTON_CONFIG);
                model.addAttribute(BUTTON_CONFIG, APPLE_PAY_CART_BUTTON_CONFIG);
                break;
            case MINICART:
                applePayButtonConfig = payPalButtonConfigurationService.parsingJsonStringIntoApplePayButtonConfigData(APPLE_PAY_MINI_CART_BUTTON_CONFIG);
                model.addAttribute(BUTTON_CONFIG, APPLE_PAY_MINI_CART_BUTTON_CONFIG);
                break;
            case BILLING:
                applePayButtonConfig = payPalButtonConfigurationService.parsingJsonStringIntoApplePayButtonConfigData(APPLE_PAY_MARK_BUTTON_CONFIG);
                model.addAttribute(BUTTON_CONFIG, APPLE_PAY_MARK_BUTTON_CONFIG);
                break;
        }
        setEssentialValuesForApplePayButton(model);
        model.addAttribute(LOCATION, location);
        model.addAttribute(LABEL, "ApplePay Page Smart Button configuration");
        model.addAttribute(APPLE_PAY_COMPONENT, applePayButtonConfig);
        return "applePayButtonConfig";
    }

    @RequestMapping(value = "/button/config/applePay/save", method = RequestMethod.GET)
    public String saveApplePayDropInButtonConfig(HttpServletRequest request,  HttpServletResponse response,
                                                 @RequestParam(required = false, defaultValue = CART)
                                                 final String location, ModelMap model) {
        final String buttonConfig = request.getParameter(BUTTON_CONFIG);
        payPalButtonConfigurationService.handleApplePayStyleDataUpdate(request, buttonConfig);
        return "redirect:/braintreehac/button/config/applePay?location=" + location;
    }

    private void setEssentialValues(ModelMap model) {
        model.addAttribute("location", payPalButtonConfigurationService.getSmartButtonLocation());
        model.addAttribute("color", payPalButtonConfigurationService.getSmartButtonColor());
        model.addAttribute("shape", payPalButtonConfigurationService.getSmartButtonShape());
        model.addAttribute("height", payPalButtonConfigurationService.getSmartButtonHeight());
        model.addAttribute("label", payPalButtonConfigurationService.getSmartButtonLabel());
        model.addAttribute("layout", payPalButtonConfigurationService.getSmartButtonLayout());
    }

    private void setEssentialValuesForGooglePayButton(ModelMap model) {
        model.addAttribute("location", payPalButtonConfigurationService.getSmartButtonLocation());
        model.addAttribute("size", payPalButtonConfigurationService.getGooglePaySmartButtonSize());
        model.addAttribute("type", payPalButtonConfigurationService.getGooglePaySmartButtonType());
    }

    private void setEssentialValuesForApplePayButton(ModelMap model) {
        model.addAttribute("location", payPalButtonConfigurationService.getSmartButtonLocation());
        model.addAttribute("color", payPalButtonConfigurationService.getApplePaySmartButtonColor());
        model.addAttribute("type", payPalButtonConfigurationService.getApplePaySmartButtonType());
        model.addAttribute("shape", payPalButtonConfigurationService.getApplePaySmartButtonShape());
    }

}
