<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<% pageContext.setAttribute("newLineChar", "\n"); %>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>PayPal Button Config</title>

</head>
<body>
<div class="marginLeft prepend-top span-17">

    <h2>${pageLabel}</h2>
    <div style="display: flex; justify-content: flex-start;">
        <div class="dataTable no-footer" style="width: 450px">
            <form action="/hac/braintreehac/button/config/payPal/save" method="GET">
                <div id="locationContainer">
                    <label for="location"> Choose a location: </label>
                    <select name="location" id="location" onchange="changePlacing(this.value)">
                        <c:forEach var="item" items="${location}">
                            <option value="${item}" ${item == locationFromController ? 'selected="selected"' : ''}>${item}</option>
                        </c:forEach>
                    </select>
                </div>
                <div id="colorContainer">
                    <label for="color"> Choose a color:</label>
                    <select name="color" id="color" onchange="changeColor(this.value)">
                        <c:forEach var="item" items="${color}">
                            <option value="${item}" ${item == payPalComponent.color ? 'selected="selected"' : ''}>${item}</option>
                        </c:forEach>
                    </select>
                </div>
                <div id="shapeContainer">
                    <label for="shape"> Choose a shape:</label>
                    <select name="shape" id="shape" onchange="changeShape(this.value)">
                        <c:forEach var="item" items="${shape}">
                            <option value="${item}" ${item == payPalComponent.shape ? 'selected="selected"' : ''}>${item}</option>
                        </c:forEach>
                    </select>
                </div>
                <div id="heightContainer">
                    <label for="height"> Choose a height:</label>
                    <select name="height" id="height" onchange="changeHeight(this.value)">
                        <c:forEach var="item" items="${height}">
                            <option value="${item}" ${item == payPalComponent.height ? 'selected="selected"' : ''}>${item}</option>
                        </c:forEach>
                    </select>
                </div>
                <div id="labelContainer">
                    <label for="label"> Choose a label:</label>
                    <select name="label" id="label" onchange="changeLabel(this.value)">
                        <c:forEach var="item" items="${label}">
                            <option value="${item}" ${item == payPalComponent.label ? 'selected="selected"' : ''}>${item}</option>
                        </c:forEach>
                    </select>
                </div>
                <div id="layoutContainer">
                    <label for="layout"> Choose a layout:</label>
                    <select name="layout" id="layout" onchange="changeLayout(this.value)">
                        <c:forEach var="item" items="${layout}">
                            <option value="${item}" ${item == payPalComponent.layout ? 'selected="selected"' : ''}>${item}</option>
                        </c:forEach>
                    </select>
                </div>
                <input name="buttonConfig" value="${buttonConfig}" type="hidden"/>

                <div id="checkbox">
                    <label id="payPalButtonTaglineLabel" style="${payPalComponent.layout == 'vertical' ? 'color:lightgrey' : ''}">
                        <input id="payPalButtonTagline" name="tagline" type="checkbox" value="true"
                        ${payPalComponent.tagline == true ? 'checked' : ''} ${payPalComponent.layout == 'vertical' ? 'disabled' : ''} onclick="changeTagline(this)"/>
                        Enable Tagline
                    </label>
                </div>

                <input style="margin-top: 30px" type="submit" value="Save">
                <br></br>

            </form>
        </div>

        <div id="smart-button-container" style="text-align: center; width: 600px; height: 170px; margin-top: 10px; background-color: white; pointer-events: none">
            <div style="text-align: center; width: 500px; margin: 50px 50px 0px 50px;">
                <span id="paypal-button-container"></span>
            </div>
        </div>
    </div>
</div>


<script src="https://www.paypal.com/sdk/js?client-id=sb&currency=USD&disable-funding=credit,card&enable-funding=paypal" data-sdk-integration-source="button-factory"></script>
<script>

    let buttonColorFromController = '${payPalComponent.color}'.toLowerCase();
    let buttonShapeFromController = '${payPalComponent.shape}';
    let buttonHeightFromController = Number('${payPalComponent.height}');
    let buttonLabelFromController = '${payPalComponent.label}'.toLowerCase();
    let buttonLayoutFromController = '${payPalComponent.layout}';
    let buttonTaglineFromController = '${payPalComponent.tagline}';

    let buttonColorFromView = buttonColorFromController;
    let buttonShapeFromView = buttonShapeFromController;
    let buttonHeightFromView = buttonHeightFromController;
    let buttonLabelFromView = buttonLabelFromController;
    let buttonLayoutFromView = buttonLayoutFromController;
    let buttonTaglineFromView = buttonTaglineFromController;

    renderButton(buttonColorFromController, buttonShapeFromController, buttonHeightFromController, buttonLabelFromController, buttonLayoutFromController, buttonTaglineFromController);

    function changeColor(changeColor) {
        buttonColorFromView = changeColor.toString().toLowerCase();
        renderButton(buttonColorFromView, buttonShapeFromView, buttonHeightFromView, buttonLabelFromView, buttonLayoutFromView, buttonTaglineFromView);
    }
    function changeShape(changeShape) {
        buttonShapeFromView = changeShape.toString().toLowerCase();
        renderButton(buttonColorFromView, buttonShapeFromView, buttonHeightFromView, buttonLabelFromView, buttonLayoutFromView, buttonTaglineFromView);
    }
    function changeHeight(changeHeight) {
        buttonHeightFromView = Number(changeHeight);
        renderButton(buttonColorFromView, buttonShapeFromView, buttonHeightFromView, buttonLabelFromView, buttonLayoutFromView, buttonTaglineFromView);
    }
    function changeLabel(changeLabel) {
        buttonLabelFromView = changeLabel.toString();
        renderButton(buttonColorFromView, buttonShapeFromView, buttonHeightFromView, buttonLabelFromView, buttonLayoutFromView, buttonTaglineFromView);
    }
    function changeLayout(changeLayout) {
        buttonLayoutFromView = changeLayout.toString();
        renderButton(buttonColorFromView, buttonShapeFromView, buttonHeightFromView, buttonLabelFromView, buttonLayoutFromView, buttonTaglineFromView);
    }

    function changeTagline(changeTagline) {
        buttonTaglineFromView = Boolean(changeTagline.checked);
        renderButton(buttonColorFromView, buttonShapeFromView, buttonHeightFromView, buttonLabelFromView, buttonLayoutFromView, buttonTaglineFromView);
    }

    function renderButton(buttonColor, buttonShape, buttonHeight, buttonLabel, buttonLayout, buttonTagline) {

        if (!selectLayout(buttonLayout)) {
            buttonTagline = false;
            buttonTaglineFromView = false;
        }

        document.getElementById('paypal-button-container').innerHTML = ""
        function initPayPalButton() {
            paypal.Buttons({
                style: {
                    shape: buttonShape,
                    color: buttonColor,
                    label: buttonLabel,
                    height: buttonHeight,
                    layout: buttonLayout,
                    tagline: buttonTagline,
                }
            }).render('#paypal-button-container');
        }

        initPayPalButton();
    }

    function changePlacing(location) {
        window.location.href = "/hac/braintreehac/button/config/payPal?location=" + location;
    }

    function selectLayout(selectedValue) {
        let tagLineElement = document.getElementById('payPalButtonTagline');
        if (selectedValue === 'vertical') {
            tagLineElement.checked = false;
            tagLineElement.disabled = true;
            document.getElementById('payPalButtonTaglineLabel').style = 'color:lightgrey';
            return false;
        } else {
            tagLineElement.disabled = false;
            document.getElementById('payPalButtonTaglineLabel').style = '';
            return true;
        }
    }
</script>

</body>
</html>
