<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<% pageContext.setAttribute("newLineChar", "\n"); %>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Google Pay Button Config</title>
    <style>
        button {
            background: black;
        }
    </style>
</head>
<body>
<div class="marginLeft prepend-top span-17">

    <h2>${pageLabel}</h2>

    <div style="display: flex; justify-content: flex-start;">
        <div class="dataTable no-footer" style="width: 450px">
            <form action="/hac/braintreehac/button/config/googlePay/save" method="GET">
                <div id="locationContainer">
                    <label for="location"> Choose a location: </label>
                    <select name="location" id="location" onchange="changeLocation(this.value)">
                        <c:forEach var="item" items="${location}">
                            <option value="${item}" ${item == locationFromController ? 'selected="selected"' : ''}>${item}</option>
                        </c:forEach>
                    </select>
                </div>
                <div id="sizeContainer">
                    <label for="size"> Choose a Size:</label>
                    <select name="size" id="size" onchange="changeSize(this.value)">
                        <c:forEach var="item" items="${size}">
                            <option value="${item}" ${item == googlePayComponent.size ? 'selected="selected"' : ''}>${item}</option>
                        </c:forEach>
                    </select>
                </div>
                <div id="typeContainer">
                    <label for="type"> Choose a type:</label>
                    <select name="type" id="type" onchange="changeType(this.value)">
                        <c:forEach var="item" items="${type}">
                            <option value="${item}" ${item == googlePayComponent.type ? 'selected="selected"' : ''}>${item}</option>
                        </c:forEach>
                    </select>
                </div>

                <input name="buttonConfig" value="${buttonConfig}" type="hidden"/>

                <input style="margin-top: 30px" type="submit" value="Save">
                <br></br>

            </form>
        </div>


        <div style="text-align: center; width: 500px; height: 140px; margin-top: 10px; background-color: white; pointer-events: none">
            <div id="google-pay-main-container" style="text-align: center; margin-top: 50px;">
                <span id="google-pay-container"></span>
            </div>
        </div>
    </div>

</div>
    <script src="https://pay.google.com/gp/p/js/pay.js"></script>
    <script>
        const baseRequest = {
            apiVersion: 2,
            apiVersionMinor: 0
        };

        const allowedCardNetworks = [""];

        const allowedCardAuthMethods = ["PAN_ONLY"];

        const tokenizationSpecification = {
            type: 'PAYMENT_GATEWAY',
            parameters: {
                'gateway': '',
                'gatewayMerchantId': ''
            }
        };

        const baseCardPaymentMethod = {
            type: 'CARD',
            parameters: {
                allowedAuthMethods: allowedCardAuthMethods,
                allowedCardNetworks: allowedCardNetworks
            }
        };

        const cardPaymentMethod = Object.assign(
            {},
            baseCardPaymentMethod,
            {
                tokenizationSpecification: tokenizationSpecification
            }
        );

        let paymentsClient = null;

        function getGoogleIsReadyToPayRequest() {
            return Object.assign(
                {},
                baseRequest,
                {
                    allowedPaymentMethods: [baseCardPaymentMethod]
                }
            );
        }

        function getGooglePaymentDataRequest() {
            const paymentDataRequest = Object.assign({}, baseRequest);
            paymentDataRequest.allowedPaymentMethods = [cardPaymentMethod];
            paymentDataRequest.transactionInfo = getGoogleTransactionInfo();
            paymentDataRequest.merchantInfo = {
                merchantName: ''
            };

            paymentDataRequest.callbackIntents = ["PAYMENT_AUTHORIZATION"];

            return paymentDataRequest;
        }

        function getGooglePaymentsClient() {
            if ( paymentsClient === null ) {
                paymentsClient = new google.payments.api.PaymentsClient({
                    environment: '',
                    paymentDataCallbacks: {
                        onPaymentAuthorized: onPaymentAuthorized
                    }
                });
            }
            return paymentsClient;
        }

        function onPaymentAuthorized(paymentData) {}

        function onGooglePayLoaded(buttonSize, buttonType) {

            if(buttonSize === 'static') {
                document.getElementById("google-pay-main-container").style.marginLeft = "130px";
            } else {
                document.getElementById("google-pay-main-container").style.marginLeft = "0px";
            }

            document.getElementById('google-pay-container').innerHTML = ""
            const paymentsClient = getGooglePaymentsClient();
            paymentsClient.isReadyToPay(getGoogleIsReadyToPayRequest())
                .then(function(response) {
                    if (response.result) {
                        addGooglePayButton(buttonSize, buttonType);
                    }
                })
                .catch(function(err) {
                    console.error(err);
                });
        }

        function addGooglePayButton(buttonSize, buttonType) {
            const paymentsClient = getGooglePaymentsClient();
            const button =
                paymentsClient.createButton({
                    buttonSizeMode: buttonSize,
                    buttonType: buttonType,
                    onClick: onGooglePaymentButtonClicked});
            document.getElementById('google-pay-container').appendChild(button);
        }

        function getGoogleTransactionInfo() {
            return {
                displayItems: [
                    {
                        label: "",
                        type: "",
                        price: "",
                    }
                ],
                countryCode: '',
                currencyCode: "",
                totalPriceStatus: "",
                totalPrice: "",
                totalPriceLabel: ""
            };
        }

        function onGooglePaymentButtonClicked() {}

        let buttonSizeFromController = '${googlePayComponent.size}';
        let buttonTypeFromController = '${googlePayComponent.type}';

        let buttonSizeFromView = buttonSizeFromController;
        let buttonTypeFromView = buttonTypeFromController;

        onGooglePayLoaded(buttonSizeFromController, buttonTypeFromController);

        function changeSize(changeSize) {
            buttonSizeFromView = changeSize.toString().toLowerCase();
            onGooglePayLoaded(buttonSizeFromView, buttonTypeFromView);
        }
        function changeType(changeType) {
            buttonTypeFromView = changeType.toString();
            onGooglePayLoaded(buttonSizeFromView, buttonTypeFromView);
        }

        function changeLocation(location) {
            window.location.href = "/hac/braintreehac/button/config/googlePay?location=" + location;
        }
    </script>
</body>
</html>
