<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<% pageContext.setAttribute("newLineChar", "\n"); %>

<!DOCTYPE html>
<html lang="en">
    <head>
    <title>Drop-In Button Customization</title>

    </head>
    <body>
        <div class="marginLeft prepend-top span-17">

            <h2>${pageLabel}</h2>

            <div class="dataTable no-footer">
                <form action="/hac/braintreehac/dropIn/config/payPal/save?placing=${item}" method="GET">
                    <div id="placingDropInContainer">
                        <label for="placingDropIn"> Choose a placing: </label>
                        <select name="placing" id="placingDropIn" onchange="changePlacing(this.value)">
                            <c:forEach var="item" items="${placingDropIn}">
                                <option value="${item}" ${item == placingFromController ? 'selected="selected"' : ''}>${item}</option>
                            </c:forEach>
                        </select>
                    </div>
                    <div id="colorDropIn">
                        <label for="color"> Choose a color: </label>
                        <select name="color" id="color">
                            <c:forEach var="item" items="${color}">
                                <option value="${item}" ${item == dropInComponent.color ? 'selected="selected"' : ''}>${item}</option>
                            </c:forEach>
                        </select>
                    </div>
                    <div id="shapeDropIn">
                        <label for="shape"> Choose a shape: </label>
                        <select name="shape" id="shape">
                            <c:forEach var="item" items="${shape}">
                                <option value="${item}" ${item == dropInComponent.shape ? 'selected="selected"' : ''}>${item}</option>
                            </c:forEach>
                        </select>
                    </div>
                    <div id="labelDropIn">
                        <label for="label"> Choose a label: </label>
                        <select name="label" id="label">
                            <c:forEach var="item" items="${label}">
                                <option value="${item}" ${item == dropInComponent.label ? 'selected="selected"' : ''}>${item}</option>
                            </c:forEach>
                        </select>
                    </div>
                    <div id="layoutDropIn">
                        <label for="layout"> Choose a layout: </label>
                        <select name="layout" id="layout" onchange="selectLayout(this.value)">
                            <c:forEach var="item" items="${layout}">
                                <option value="${item}" ${item == dropInComponent.layout ? 'selected="selected"' : ''}>${item}</option>
                            </c:forEach>
                        </select>
                    </div>

                    <div id="checkbox">
                        <label id="payPalButtonTaglineLabel" style="${dropInComponent.layout == 'vertical' ? 'color:lightgrey' : ''}">
                            <input id="payPalButtonTagline" name="tagline" type="checkbox" value="true"
                            ${dropInComponent.tagline == true ? 'checked' : ''} ${dropInComponent.layout == 'vertical' ? 'disabled' : ''}/>
                            Enable Tagline
                        </label>
                    </div>

                    <br>
                    <div style="margin-bottom: 4px">
                        <input type="submit" value="Save">
                    </div>
                    <br>
                </form>
            </div>
        </div>

        <script>
            function changePlacing(placing) {
                window.location.href = "/hac/braintreehac/dropIn/config/payPal?placing=" + placing;
            }

            function selectLayout(selectedValue) {
                let tagLineElement = document.getElementById('payPalButtonTagline');
                if (selectedValue === 'vertical') {
                    tagLineElement.checked = false;
                    tagLineElement.disabled = true;
                    document.getElementById('payPalButtonTaglineLabel').style = 'color:lightgrey';
                } else {
                    tagLineElement.disabled = false;
                    document.getElementById('payPalButtonTaglineLabel').style = '';
                }
            }
        </script>

    </body>
</html>