<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<% pageContext.setAttribute("newLineChar", "\n"); %>
<link href="../static/css/connectWithPayPalStyle.css" rel="stylesheet" type="text/css">

<div>
    <div class="superContainer marginLeft prepend-top span-17">
        <h2>Connect With PayPal Button Configuration</h2>
        <div id="mainContainer dataTable no-footer" class="flexContainer">
            <div class="firstContainer dataTable no-footer">
                <form:form action="/hac/braintreehac/connectWithPayPalConfigurations/save" method="POST">
                    <div id="buttonTypeContainer">
                        <label for="buttonType"> Choose a button type:</label>
                        <select name="buttonType" id="buttonType" onchange="changeType(this.value)">
                            <c:forEach var="item" items="${buttonType}">
                                <option value="${item}" ${item == payPalConnect.buttonType ? 'selected="selected"' : ''}>${item}</option>
                            </c:forEach>
                        </select>
                    </div>
                    <div id="buttonShapeContainer">
                        <label for="buttonShape"> Choose a button shape:</label>
                        <select name="buttonShape" id="buttonShape" onchange="changeShape(this.value)">
                            <c:forEach var="item" items="${buttonShape}">
                                <option value="${item}" ${item == payPalConnect.buttonShape ? 'selected="selected"' : ''}>${item.toLowerCase()}</option>
                            </c:forEach>
                        </select>
                        <br/>
                    </div>
                    <div id="buttonSizeContainer">
                        <label for="buttonSize"> Choose a button size:</label>
                        <select name="buttonSize" id="buttonSize" onchange="changeSize(this.value)">
                            <c:forEach var="item" items="${buttonSize}">
                                <option value="${item}" ${item == payPalConnect.buttonSize ? 'selected="selected"' : ''}>${item.toLowerCase()}</option>
                            </c:forEach>
                        </select>
                    </div>
                    <div id="buttonThemeContainer">
                        <label for="buttonTheme"> Choose a button theme:</label>
                        <select name="buttonTheme" id="buttonTheme" onchange="changeTheme(this.value)">
                            <c:forEach var="item" items="${buttonTheme}">
                                <option value="${item}" ${item == payPalConnect.buttonTheme ? 'selected="selected"' : ''}>${item.toLowerCase()}</option>
                            </c:forEach>
                        </select>
                        <br/>
                    </div>
                    <input name="uid" value="${componentUid}" type="hidden"/>
                    <div id="checkbox">
                        <label>
                            <input id="hiddenEnabledPayPalConnect" name="enabled" type="hidden"/>
                            <input id="enabledPayPalConnect" name="enabled" type="checkbox" value="true" onchange="changeEnabled()" ${payPalConnect.enabled == true ? 'checked' : ''} />
                            Enable Connect With PayPal
                        </label>
                    </div>
                    <br>
                    <input type="submit" value="Save">
                    <br>
                </form:form>
            </div>
            <div class="secondContainer">
                <div class="connectWithPayPalContainer">
                    <div id="paypalConnectButtonContainer">
                        <span id='paypal-connect-button'></span>
                    </div>
                </div>
                <div class="messageAboutSavingContainer">
                    <h3 id="messageAboutSavingChanges"></h3>
                </div>
            </div>
        </div>
    </div>
</div>
<script src='https://www.paypalobjects.com/js/external/api.js'></script>
<script type="text/javascript" src="../static/js/connectWithPayPal.js"></script>
<script>
    let buttonThemeFromController = '${payPalConnect.buttonTheme}'.toLowerCase();
    let buttonTypeFromController = '${payPalConnect.buttonType}';
    let buttonShapeFromController = '${payPalConnect.buttonShape}'.toLowerCase();
    let buttonSizeFromController = '${payPalConnect.buttonSize}'.toLowerCase();
    let buttonEnabledFromController = ${payPalConnect.enabled};

    let buttonThemeFromView = buttonThemeFromController;
    let buttonTypeFromView = buttonTypeFromController;
    let buttonShapeFromView = buttonShapeFromController;
    let buttonSizeFromView = buttonSizeFromController;
    let buttonEnabledFromView = buttonEnabledFromController;

    // This method is called to render the Connect with PayPal button the first time.
    renderButton();

    function renderButton() {
        doShowPaypalConnectButtonContainer()
        messageAboutSavingChanges();
        var authend = '';
        if ('${environmentType}' === 'sandbox') {
            authend = 'sandbox';
        }

        paypal.use( ['login'], function (login) {
            login.render ({
                'appid': '',
                'authend': authend,
                'scopes': '${payPalConnectScopes}',
                'containerid': '${payPalConnect.buttonDiv}',
                'responseType': '${payPalConnectResponseType}',
                'theme': buttonThemeFromView,
                'buttonType': buttonTypeFromView,
                'buttonShape': buttonShapeFromView,
                'buttonSize': buttonSizeFromView,
                'fullPage': '${payPalConnect.fullPage}',
                'nonce': '11111111',
                'returnurl': ''
            });
        });
    }
</script>