<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<% pageContext.setAttribute("newLineChar", "\n"); %>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Apple Pay Button Config</title>

</head>
<body>
<div class="marginLeft prepend-top span-17">

    <h2>${pageLabel}</h2>

    <div style="display: flex; justify-content: flex-start;">
        <div class="dataTable no-footer" style="width: 450px">
            <form action="/hac/braintreehac/button/config/applePay/save" method="GET">
                <div id="locationContainer">
                    <label for="location"> Choose a location: </label>
                    <select name="location" id="location" onchange="changeLocation(this.value)">
                        <c:forEach var="item" items="${location}">
                            <option value="${item}" ${item == locationFromController ? 'selected="selected"' : ''}>${item}</option>
                        </c:forEach>
                    </select>
                </div>
                <div id="colorContainer">
                    <label for="color"> Choose a color:</label>
                    <select name="color" id="color" onchange="changeColor(this.value)">
                        <c:forEach var="item" items="${color}">
                            <option value="${item}" ${item == applePayComponent.color ? 'selected="selected"' : ''}>${item}</option>
                        </c:forEach>
                    </select>
                </div>
                <div id="typeContainer">
                    <label for="type"> Choose a type:</label>
                    <select name="type" id="type" onchange="changeType(this.value)">
                        <c:forEach var="item" items="${type}">
                            <option value="${item}" ${item == applePayComponent.type ? 'selected="selected"' : ''}>${item}</option>
                        </c:forEach>
                    </select>
                </div>
                <div id="shapeContainer">
                    <label for="shape"> Choose a Shape:</label>
                    <select name="shape" id="shape" onchange="changeShape(this.value)">
                        <c:forEach var="item" items="${shape}">
                            <option value="${item}" ${item == applePayComponent.shape ? 'selected="selected"' : ''}>${item}</option>
                        </c:forEach>
                    </select>
                </div>

                <input name="buttonConfig" value="${buttonConfig}" type="hidden"/>

                <input style="margin-top: 30px" type="submit" value="Save">
                <br></br>

            </form>
        </div>

        <div id="apple-pay-main-container-id" class="apple-pay-main-container-class" style="width: 500px; height: 140px; text-align: center; margin-top: 10px; background-color: silver;">
            <div id="apple-pay-container-id" style="text-align: center; margin-top: 50px;">

                <script src="https://applepay.cdn-apple.com/jsapi/v1/apple-pay-sdk.js"></script>
                <style>
                apple-pay-button {
                  --apple-pay-button-border-radius: 0px;
                }
                </style>
                <apple-pay-button id="id1" buttonstyle="${applePayComponent.color}" type="${applePayComponent.type}" locale="en-US"></apple-pay-button>

            </div>

        </div>
    </div>


</div>
<script>

    let appleShapeFromController = '${applePayComponent.shape}';
    changeShape(appleShapeFromController);

    if (window.ApplePaySession === undefined) {
        let applePayIsNotAvailable = document.getElementById('apple-pay-container-id');
        applePayIsNotAvailable.innerHTML += 'This device does not support Apple Pay Button';
    }

    function changeColor(color) {
        const applePayButton = document.querySelector("apple-pay-button");
        applePayButton.setAttribute("buttonstyle", color);
    }

    function changeType(type) {
        const applePayButton = document.querySelector("apple-pay-button");
        applePayButton.setAttribute("type", type);
    }

    function changeShape(shape) {
        if (shape === 'squareCorners') {
            document.getElementById('id1').style = '--apple-pay-button-border-radius: 0px';
        } else if (shape === 'pill-shaped') {
            document.getElementById('id1').style = '--apple-pay-button-border-radius: 15px';
        }
    }

    function changeLocation(location) {
    window.location.href = "/hac/braintreehac/button/config/applePay?location=" + location;
    }

</script>

</body>
</html>
