/**
 *
 */
package com.braintree.impl;

import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.AbstractOrderEntryModel;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.core.model.order.delivery.DeliveryModeModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.core.model.user.AddressModel;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

@UnitTest
public class DefaultBrainTreeCheckOrderServiceTest {

    private DefaultCheckOrderService unit;

    private OrderModel orderModel;

    private AbstractOrderEntryModel entryModel;

    private List<AbstractOrderEntryModel> entryModelList;

    private PaymentInfoModel paymentInfoModel;

    private AddressModel addressModel;

    @Before
    public void setUp() {
        unit = new DefaultCheckOrderService();
        orderModel = Mockito.mock(OrderModel.class);
        entryModel = Mockito.mock(AbstractOrderEntryModel.class);
        entryModelList = new ArrayList<>();
        entryModelList.add(entryModel);
        paymentInfoModel = Mockito.mock(PaymentInfoModel.class);
        addressModel = Mockito.mock(AddressModel.class);
    }

    @Test
    public void shouldReturnFalseIfOrderNotCalculated() {
        Assert.assertFalse(unit.check(orderModel));
    }

    @Test
    public void shouldReturnFalseIfOrderNotHaveAnyEntries() {
        when(orderModel.getCalculated()).thenReturn(Boolean.TRUE);
        Assert.assertFalse(unit.check(orderModel));
    }

    @Test
    public void shouldReturnFalseIfOrderModelNotHavePaymentInfo() {
        when(orderModel.getCalculated()).thenReturn(Boolean.TRUE);
        when(orderModel.getEntries()).thenReturn(entryModelList);
        Assert.assertFalse(unit.check(orderModel));
    }

    @Test
    public void shouldReturnFalseIfGetDeliveryModeNull() {
        when(orderModel.getCalculated()).thenReturn(Boolean.TRUE);
        when(orderModel.getEntries()).thenReturn(entryModelList);
        when(orderModel.getPaymentInfo()).thenReturn(paymentInfoModel);
        Assert.assertFalse(unit.check(orderModel));
    }

    @Test
    public void shouldReturnFalseIfDeliveryAddressNull() {
        DeliveryModeModel deliveryModeModel = Mockito.mock(DeliveryModeModel.class);

        when(orderModel.getCalculated()).thenReturn(Boolean.TRUE);
        when(orderModel.getEntries()).thenReturn(entryModelList);
        when(orderModel.getPaymentInfo()).thenReturn(paymentInfoModel);
        when(orderModel.getDeliveryMode()).thenReturn(deliveryModeModel);
        Assert.assertFalse(unit.check(orderModel));
    }

    @Test
    public void shouldReturnTrueIfOrderModelHaveAllNeededFileds() {
        DeliveryModeModel deliveryModeModel = Mockito.mock(DeliveryModeModel.class);
        when(orderModel.getCalculated()).thenReturn(Boolean.TRUE);
        when(orderModel.getEntries()).thenReturn(entryModelList);
        when(orderModel.getPaymentInfo()).thenReturn(paymentInfoModel);
        when(orderModel.getDeliveryMode()).thenReturn(deliveryModeModel);
        when(orderModel.getDeliveryAddress()).thenReturn(addressModel);
        Assert.assertTrue(unit.check(orderModel));
    }
}
