package com.braintree.actions.order;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.core.model.order.payment.InvoicePaymentInfoModel;
import de.hybris.platform.orderprocessing.model.OrderProcessModel;
import de.hybris.platform.processengine.action.AbstractSimpleDecisionAction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

import static org.mockito.Mockito.when;

@UnitTest
public class BrainTreeCheckAuthorizeOrderPaymentActionTest {

    @InjectMocks
    BrainTreeCheckAuthorizeOrderPaymentAction brainTreeCheckAuthorizeOrderPaymentAction;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void executeActionShouldReturnNOkStatus() {
        OrderProcessModel orderProcessModel = Mockito.mock(OrderProcessModel.class);
        OrderModel orderModel = Mockito.mock(OrderModel.class);

        when(orderProcessModel.getOrder()).thenReturn(orderModel);

        AbstractSimpleDecisionAction.Transition result = brainTreeCheckAuthorizeOrderPaymentAction.executeAction(orderProcessModel);
        Assert.assertEquals(result, AbstractSimpleDecisionAction.Transition.NOK);
    }

    @Test
    public void executeActionShouldReturnOkStatus() {
        OrderProcessModel orderProcessModel = Mockito.mock(OrderProcessModel.class);
        OrderModel orderModel = Mockito.mock(OrderModel.class);
        InvoicePaymentInfoModel invoicePaymentInfoModel = Mockito.mock(InvoicePaymentInfoModel.class);

        when(orderProcessModel.getOrder()).thenReturn(orderModel);
        when(orderModel.getPaymentInfo()).thenReturn(invoicePaymentInfoModel);

        AbstractSimpleDecisionAction.Transition result = brainTreeCheckAuthorizeOrderPaymentAction.executeAction(orderProcessModel);

        Assert.assertEquals(result, AbstractSimpleDecisionAction.Transition.OK);
    }
}
