/*

 */
package com.braintree.email.listeners;

import com.braintree.email.emailEvents.BraintreeLocalPaymentReversedEmailEvent;
import com.braintree.model.BraintreeLocalPaymentReversedEmailProcessModel;
import de.hybris.platform.acceleratorservices.site.AbstractAcceleratorSiteEventListener;
import de.hybris.platform.processengine.BusinessProcessService;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.commerceservices.enums.SiteChannel;
import de.hybris.platform.basecommerce.model.site.BaseSiteModel;
import org.springframework.beans.factory.annotation.Required;

public class BraintreeLocalPaymentReversedEmailEventListener extends AbstractAcceleratorSiteEventListener<BraintreeLocalPaymentReversedEmailEvent>
{


    private ModelService modelService;
    private BusinessProcessService businessProcessService;


    protected BusinessProcessService getBusinessProcessService()
    {
        return businessProcessService;
    }

    @Required
    public void setBusinessProcessService(final BusinessProcessService businessProcessService)
    {
        this.businessProcessService = businessProcessService;
    }

    protected ModelService getModelService()
    {
        return modelService;
    }

    @Required
    public void setModelService(final ModelService modelService)
    {
        this.modelService = modelService;
    }


    @Override
    protected SiteChannel getSiteChannelForEvent(BraintreeLocalPaymentReversedEmailEvent event)
    {
        final BaseSiteModel site = event.getSite();

        return site.getChannel();
    }

    @Override
    protected void onSiteEvent(final BraintreeLocalPaymentReversedEmailEvent event)
    {
       final BraintreeLocalPaymentReversedEmailProcessModel braintreeEmailProcess =  getBusinessProcessService()
               .createProcess("BraintreeLocalPaymentReversed- " + event.getCustomer().getUid() + "-" + System.currentTimeMillis(),
                       "braintreeLocalPaymentReversedEmailProcess");
       braintreeEmailProcess.setSite(event.getSite());
       braintreeEmailProcess.setCustomer(event.getCustomer());
       braintreeEmailProcess.setLanguage(event.getLanguage());
       braintreeEmailProcess.setCurrency(event.getCurrency());
       braintreeEmailProcess.setStore(event.getBaseStore());

       braintreeEmailProcess.setContent(event.getContent());
       braintreeEmailProcess.setOrderId(event.getOrderModel().getCode());
       braintreeEmailProcess.setOrderTotalPrice(event.getOrderModel().getTotalPrice().toString());

       getModelService().save(braintreeEmailProcess);
       getBusinessProcessService().startProcess(braintreeEmailProcess);
    }

}
